/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.DelegatedTimeoutManager;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.RecoveryStateHolder;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.codegen.jtsxa.OTSResource;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.Status;

public class DelegatedRecoveryManager {
    private static Hashtable recoveryStatetable = new Hashtable();
    private static Hashtable tmoutMgrtable = new Hashtable();
    static Logger _logger = LogDomains.getLogger(DelegatedRecoveryManager.class, (String)"javax.enterprise.system.core.transaction");

    static synchronized DelegatedTimeoutManager getTimeoutManager(String logPath) {
        DelegatedTimeoutManager tmoutMgr = (DelegatedTimeoutManager)tmoutMgrtable.get(logPath);
        if (tmoutMgr != null) {
            return tmoutMgr;
        }
        tmoutMgr = new DelegatedTimeoutManager(logPath);
        tmoutMgrtable.put(logPath, tmoutMgr);
        return tmoutMgr;
    }

    static boolean addCoordinator(GlobalTID globalTID, Long localTID, CoordinatorImpl coord, int timeout, String logPath) {
        boolean result = true;
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        state.coordsByGlobalTID.put(globalTID, coord);
        state.coordsByLocalTID.put(localTID, coord);
        if (timeout != 0) {
            DelegatedTimeoutManager tmoutMgr = DelegatedRecoveryManager.getTimeoutManager(logPath);
            tmoutMgr.setTimeout(localTID, 1, timeout);
        }
        return result;
    }

    static boolean removeCoordinator(GlobalTID globalTID, Long localTID, boolean aborted, String logPath) {
        boolean result = false;
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        CoordinatorImpl coord = null;
        boolean bl = result = state.coordsByGlobalTID.remove(globalTID) != null;
        if (result) {
            coord = (CoordinatorImpl)state.coordsByLocalTID.remove(localTID);
            boolean bl2 = result = coord != null;
        }
        if (coord != null) {
            try {
                if (coord.is_top_level_transaction()) {
                    CoordinatorLog.removeLog(localTID, logPath);
                }
            }
            catch (SystemException exc) {
                result = false;
            }
        }
        DelegatedTimeoutManager tmoutMgr = DelegatedRecoveryManager.getTimeoutManager(logPath);
        tmoutMgr.setTimeout(localTID, 0, 0);
        if (state.resyncCoords > 0) {
            --state.resyncCoords;
            if (state.resyncCoords == 0) {
                try {
                    DelegatedRecoveryManager.resyncComplete(true, true, logPath);
                }
                catch (Throwable exc) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    static CoordinatorImpl getCoordinator(GlobalTID globalTID, String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        CoordinatorImpl result = (CoordinatorImpl)state.coordsByGlobalTID.get(globalTID);
        return result;
    }

    public static boolean delegated_recover(String logPath, XAResource[] resources) throws Exception {
        try {
            File recoveryFile = new File(logPath, "recoveryfile");
            RandomAccessFile raf = new RandomAccessFile(recoveryFile, "r");
            long length = raf.length();
            byte[] b1 = new byte[(int)length];
            raf.readFully(b1);
            String serverName = new String(b1);
            raf.close();
            return DelegatedRecoveryManager.delegated_recover(serverName, logPath, resources);
        }
        catch (IOException ex) {
            _logger.log(Level.WARNING, "jts.exception_in_recovery_file_handling", ex);
            throw ex;
        }
    }

    public static boolean delegated_recover(String serverName, String logPath, XAResource[] resources) throws Exception {
        if (logPath == null || serverName == null) {
            return false;
        }
        Configuration.setServerName(logPath, serverName);
        boolean result = false;
        boolean keypointRequired = false;
        RecoveryStateHolder state = new RecoveryStateHolder();
        recoveryStatetable.put(logPath, state);
        Enumeration logRecords = CoordinatorLog.getLogged(logPath);
        while (logRecords.hasMoreElements()) {
            keypointRequired = true;
            try {
                new TopCoordinator().delegated_reconstruct((CoordinatorLog)logRecords.nextElement(), logPath);
            }
            catch (Exception exc) {
                _logger.log(Level.SEVERE, "jts.recovery_in_doubt_exception", exc);
                _logger.log(Level.SEVERE, "jts.recovery_in_doubt", exc.toString());
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.recovery_in_doubt", new Object[]{exc.toString()});
                throw new INTERNAL(msg);
            }
        }
        int size = resources.length;
        Vector<XAResource> v = new Vector<XAResource>();
        for (int i = 0; i < size; ++i) {
            v.addElement(resources[i]);
        }
        state.uniqueRMSet = DelegatedRecoveryManager.getUniqueRMSet(v.elements());
        DelegatedRecoveryManager.proceedWithXARecovery(logPath);
        state.recoveryInProgress.post();
        boolean bl = result = state.coordsByGlobalTID.size() > 0;
        if (!result) {
            try {
                DelegatedRecoveryManager.resyncComplete(false, keypointRequired, logPath);
            }
            catch (Throwable exc) {
                // empty catch block
            }
        }
        if (result) {
            DelegatedRecoveryManager.resync(logPath);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resync(String logPath) {
        RecoveryStateHolder recoveryState = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        recoveryState.resyncCoords = recoveryState.coordsByGlobalTID.size();
        Enumeration resyncList = ((Hashtable)recoveryState.coordsByGlobalTID.clone()).elements();
        boolean[] isRoot = new boolean[1];
        while (resyncList.hasMoreElements()) {
            TopCoordinator coord = (TopCoordinator)resyncList.nextElement();
            try {
                TopCoordinator topCoordinator = coord;
                synchronized (topCoordinator) {
                    Status state = coord.recover(isRoot);
                    if (state == Status.StatusUnknown) {
                        DelegatedTimeoutManager tmoutMgr = DelegatedRecoveryManager.getTimeoutManager(logPath);
                        tmoutMgr.setTimeout(new Long(coord.getLocalTID()), 2, 60);
                    } else if (state == Status.StatusCommitted) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "DelegatedRecoveryManager", "resync()", "Before invoking commit on the reconstructed coordinatorGTID is: " + coord.superInfo.globalTID.toString());
                        }
                        try {
                            coord.commit();
                        }
                        catch (Throwable exc) {
                            _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "commit"});
                        }
                        if (isRoot[0]) {
                            try {
                                coord.afterCompletion(state);
                            }
                            catch (Throwable exc) {
                                _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "after_completion"});
                            }
                        }
                    } else {
                        try {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.logp(Level.FINE, "DelegatedRecoveryManager", "resync()", "Before invoking rollback on thereconstructed coordinator :GTID is : " + coord.superInfo.globalTID.toString());
                            }
                            coord.rollback(true);
                        }
                        catch (Throwable exc) {
                            _logger.log(Level.WARNING, "jts.resync_failed", new Object[]{exc.toString(), "rollback"});
                        }
                        if (isRoot[0]) {
                            try {
                                coord.afterCompletion(Status.StatusRolledBack);
                            }
                            catch (Throwable exc) {
                                _logger.log(Level.WARNING, "jts.resync_failed", new Object[]{exc.toString(), "after_completion"});
                            }
                        }
                    }
                }
            }
            catch (Throwable exc) {
            }
        }
    }

    private static void resyncComplete(boolean resynced, boolean keypointRequired, String logPath) throws LogicErrorException {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        if (keypointRequired) {
            CoordinatorLog.keypoint(logPath);
        }
        state.resyncInProgress.post();
        state.resyncInProgress = null;
    }

    static CoordinatorImpl getLocalCoordinator(Long localTID, String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        CoordinatorImpl result = (CoordinatorImpl)state.coordsByLocalTID.get(localTID);
        return result;
    }

    static boolean validLocalTID(Long localTID, String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        boolean result = state.coordsByLocalTID.containsKey(localTID);
        return result;
    }

    static void shutdown(boolean immediate) {
        Enumeration keys = recoveryStatetable.keys();
        if (keys.hasMoreElements()) {
            String logPath = (String)keys.nextElement();
            RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
            if (!immediate && state.resyncInProgress != null) {
                try {
                    state.resyncInProgress.waitEvent();
                }
                catch (InterruptedException exc) {
                    // empty catch block
                }
            }
            if (!immediate) {
                CoordinatorLog.keypoint(logPath);
                CoordinatorLog.finalizeAll(logPath);
            }
        }
    }

    private static String stringifyXid(Xid xid) {
        int glen = xid.getGlobalTransactionId().length;
        int blen = xid.getBranchQualifier().length;
        byte[] xidRep = new byte[glen + 1 + blen];
        System.arraycopy(xid.getGlobalTransactionId(), 0, xidRep, 0, glen);
        xidRep[glen] = 44;
        System.arraycopy(xid.getBranchQualifier(), 0, xidRep, glen + 1, blen);
        return new String(xidRep);
    }

    private static Enumeration getUniqueRMSet(Enumeration xaResourceList) {
        Vector<XAResource> uniqueRMList = new Vector<XAResource>();
        while (xaResourceList.hasMoreElements()) {
            XAResource xaRes = (XAResource)xaResourceList.nextElement();
            int size = uniqueRMList.size();
            boolean match = false;
            for (int i = 0; i < size; ++i) {
                XAResource uniqueXaRes = (XAResource)uniqueRMList.elementAt(i);
                try {
                    if (!xaRes.isSameRM(uniqueXaRes)) continue;
                    match = true;
                    break;
                }
                catch (XAException xe) {
                    // empty catch block
                }
            }
            if (match) continue;
            uniqueRMList.add(xaRes);
        }
        return uniqueRMList.elements();
    }

    private static void proceedWithXARecovery(String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        Enumeration xaResources = state.uniqueRMSet;
        if (xaResources == null) {
            return;
        }
        Vector<OTSResource> otsResources = new Vector<OTSResource>();
        HashSet<Xid> uniqueXids = new HashSet<Xid>();
        while (xaResources.hasMoreElements()) {
            XAResource xaResource = (XAResource)xaResources.nextElement();
            Xid[] inDoubtXids = RecoveryManager.getInDoubtXids(xaResource);
            if (inDoubtXids == null || inDoubtXids.length == 0) continue;
            for (int i = 0; i < inDoubtXids.length; ++i) {
                String serverName;
                String branchQualifier = new String(inDoubtXids[i].getBranchQualifier());
                if (branchQualifier.startsWith(serverName = Configuration.getServerName(logPath))) {
                    String xidStr = DelegatedRecoveryManager.stringifyXid(inDoubtXids[i]);
                    if (!uniqueXids.contains(inDoubtXids[i])) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "DelegatedRecoveryManager", "proceedWithXARecovery", " This xid is UNIQUE " + inDoubtXids[i]);
                        }
                        uniqueXids.add(inDoubtXids[i]);
                        otsResources.addElement(new OTSResourceImpl(inDoubtXids[i], xaResource, null).getCORBAObjReference());
                        continue;
                    }
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.logp(Level.FINE, "DelegatedRecoveryManager", "proceedWithXARecovery", " This xid is NOTUNIQUE " + inDoubtXids[i]);
                    continue;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.logp(Level.FINE, "DelegatedRecoveryManager", "proceedWithXARecovery", " This xid doesn't belong to me " + inDoubtXids[i]);
            }
        }
        for (int i = 0; i < otsResources.size(); ++i) {
            OTSResource otsResource = (OTSResource)otsResources.elementAt(i);
            GlobalTID globalTID = new GlobalTID(otsResource.getGlobalTID());
            TopCoordinator coord = (TopCoordinator)state.coordsByGlobalTID.get(globalTID);
            if (coord == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "DelegatedRecoveryManager", "proceedWithXARecovery()", "Could  not recognize OTSResource: " + otsResource + " with tid: " + LogFormatter.convertToString(globalTID.realTID.tid) + ";Hence rolling this resource back...");
                }
                boolean infiniteRetry = true;
                int commitRetries = Configuration.getRetries();
                if (commitRetries >= 0) {
                    infiniteRetry = false;
                }
                int commitRetriesLeft = commitRetries;
                boolean exceptionisThrown = true;
                while (exceptionisThrown) {
                    try {
                        otsResource.rollback();
                        exceptionisThrown = false;
                    }
                    catch (Throwable exc) {
                        if (exc instanceof COMM_FAILURE || exc instanceof TRANSIENT) {
                            if (commitRetriesLeft > 0 || infiniteRetry) {
                                if (!infiniteRetry) {
                                    --commitRetriesLeft;
                                }
                                try {
                                    Thread.sleep(60000L);
                                }
                                catch (Throwable e) {}
                                continue;
                            }
                            _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "OTSResource rollback"});
                            exceptionisThrown = false;
                            continue;
                        }
                        _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{exc.toString(), "OTSResource rollback"});
                        exceptionisThrown = false;
                    }
                }
                continue;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.logp(Level.FINE, "DelegatedRecoveryManager", "proceedWithXARecovery()", "Recognized OTSResource: " + otsResource + " with tid: " + LogFormatter.convertToString(globalTID.realTID.tid) + ";Hence registering this resource with coordinator...");
            }
            coord.directRegisterResource(otsResource);
        }
    }

    static CoordinatorImpl[] getCoordinators(String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        int size = state.coordsByGlobalTID.size();
        CoordinatorImpl[] result = new CoordinatorImpl[size];
        Enumeration coords = state.coordsByGlobalTID.elements();
        int pos = 0;
        while (pos < size) {
            result[pos++] = (CoordinatorImpl)coords.nextElement();
        }
        return result;
    }

    static Hashtable getCoordsByGlobalTID(String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        return state.coordsByGlobalTID;
    }

    public static void waitForRecovery(String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        if (state.recoveryInProgress != null) {
            try {
                state.recoveryInProgress.waitEvent();
            }
            catch (InterruptedException exc) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(msg);
            }
        }
    }

    public static void waitForResync(String logPath) {
        RecoveryStateHolder state = (RecoveryStateHolder)recoveryStatetable.get(logPath);
        if (state.resyncInProgress != null) {
            try {
                state.resyncInProgress.waitEvent();
            }
            catch (InterruptedException exc) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(msg);
            }
        }
    }
}

