/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jtsxa;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.codegen.jtsxa.OTSResource;
import com.sun.jts.codegen.jtsxa.OTSResourceHelper;
import com.sun.jts.codegen.jtsxa.OTSResourcePOA;
import com.sun.jts.jta.TransactionState;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class OTSResourceImpl
extends OTSResourcePOA
implements OTSResource {
    private static POA poa = null;
    private OTSResource thisRef = null;
    private XAResource xaRes = null;
    private Xid xid = null;
    private TransactionState tranState = null;
    static Logger _logger = LogDomains.getLogger(OTSResourceImpl.class, (String)"javax.enterprise.system.core.transaction");
    private static NO_IMPLEMENT no_implement = new NO_IMPLEMENT("This is a locally constrained object.");

    public OTSResourceImpl(Xid xid, XAResource xaRes, TransactionState tranState) {
        this.xaRes = xaRes;
        this.xid = xid;
        this.tranState = tranState;
    }

    public void commit() throws NotPrepared, HeuristicRollback, HeuristicHazard, HeuristicMixed, SystemException {
        try {
            this.xaRes.commit(this.xid, false);
        }
        catch (Exception ex) {
            this.destroy();
            if (!(ex instanceof XAException)) {
                INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                internal.initCause((Throwable)ex);
                _logger.log(Level.WARNING, "jts.unexpected_error_occurred_twopc_commit", ex);
                throw internal;
            }
            XAException e = (XAException)ex;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "An XAException occurred in twopc commit", e);
            }
            if (e.errorCode == 6) {
                throw new HeuristicRollback(ex.getMessage());
            }
            if (e.errorCode == 8) {
                throw new HeuristicHazard(ex.getMessage());
            }
            if (e.errorCode == 5) {
                throw new HeuristicMixed(ex.getMessage());
            }
            if (e.errorCode == 105) {
                throw new NotPrepared(ex.getMessage());
            }
            if (e.errorCode == 7) {
                return;
            }
            if (e.errorCode == 4 || e.errorCode == 107 || e.errorCode == 101) {
                throw new TRANSIENT();
            }
            if (e.errorCode >= 100 && e.errorCode <= 107) {
                throw new HeuristicRollback(ex.getMessage());
            }
            INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            internal.initCause((Throwable)ex);
            _logger.log(Level.WARNING, "jts.unexpected_error_occurred_twopc_commit", ex);
            throw internal;
        }
        this.destroy();
    }

    public void commit_one_phase() throws HeuristicHazard, SystemException {
        try {
            this.xaRes.commit(this.xid, true);
        }
        catch (Exception ex) {
            this.destroy();
            if (!(ex instanceof XAException)) {
                INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                internal.initCause((Throwable)ex);
                _logger.log(Level.WARNING, "jts.unexpected_error_occurred_twopc_commit", ex);
                throw internal;
            }
            XAException e = (XAException)ex;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "An XAException occurred in c_o_p", e);
            }
            if (e.errorCode == 6) {
                throw new HeuristicHazard(ex.getMessage());
            }
            if (e.errorCode == 8) {
                throw new HeuristicHazard(ex.getMessage());
            }
            if (e.errorCode == 5) {
                throw new HeuristicHazard(ex.getMessage());
            }
            if (e.errorCode == 7) {
                return;
            }
            if (e.errorCode == 4 || e.errorCode == 107 || e.errorCode == 101) {
                throw new TRANSIENT();
            }
            if (e.errorCode >= 100 && e.errorCode <= 107) {
                HeuristicHazard hazex = new HeuristicHazard();
                hazex.initCause(ex);
                throw hazex;
            }
            if (e.errorCode == -3) {
                _logger.log(Level.WARNING, "jts.unexpected_error_occurred_twopc_commit", ex);
                throw new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
            }
            INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            internal.initCause((Throwable)ex);
            _logger.log(Level.WARNING, "jts.unexpected_error_occurred_twopc_commit", ex);
            throw internal;
        }
        this.destroy();
    }

    public void forget() {
        block2: {
            try {
                this.xaRes.forget(this.xid);
            }
            catch (XAException e) {
                if (!_logger.isLoggable(Level.FINE)) break block2;
                _logger.log(Level.FINE, "An XAException occurred in forget", e);
            }
        }
        this.destroy();
    }

    public Vote prepare() throws HeuristicHazard, HeuristicMixed {
        int rc;
        block6: {
            rc = -6;
            try {
                rc = this.xaRes.prepare(this.xid);
            }
            catch (XAException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "An XAException occurred in prepare", e);
                }
                if (e.errorCode != -7 && e.errorCode != -3) break block6;
                throw new RuntimeException(e);
            }
        }
        if (rc == 0) {
            return Vote.VoteCommit;
        }
        if (rc == 3) {
            this.destroy();
            return Vote.VoteReadOnly;
        }
        if (rc == 123456) {
            this.destroy();
            return null;
        }
        this.destroy();
        return Vote.VoteRollback;
    }

    public void rollback() throws HeuristicCommit, HeuristicMixed, HeuristicHazard, SystemException {
        try {
            if (this.tranState == null) {
                this.xaRes.rollback(this.xid);
            } else {
                this.tranState.rollback(this.xaRes);
            }
        }
        catch (Exception ex) {
            this.destroy();
            if (!(ex instanceof XAException)) {
                INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
                internal.initCause((Throwable)ex);
                _logger.log(Level.WARNING, "jts.unexpected_error_occurred_twopc_rollback", ex);
                throw internal;
            }
            XAException e = (XAException)ex;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "An XAException occurred in rollback", e);
            }
            if (e.errorCode == 7) {
                throw new HeuristicCommit(ex.getMessage());
            }
            if (e.errorCode == 8) {
                throw new HeuristicHazard(ex.getMessage());
            }
            if (e.errorCode == 5) {
                throw new HeuristicMixed(ex.getMessage());
            }
            if (e.errorCode == 7) {
                return;
            }
            if (e.errorCode == 4 || e.errorCode == 107 || e.errorCode == 101) {
                throw new TRANSIENT();
            }
            INTERNAL internal = new INTERNAL(0, CompletionStatus.COMPLETED_MAYBE);
            internal.initCause((Throwable)ex);
            _logger.log(Level.WARNING, "jts.unexpected_error_occurred_twopc_rollback", ex);
            throw internal;
        }
        this.destroy();
    }

    public otid_t getGlobalTID() {
        byte[] gtrid = this.xid.getGlobalTransactionId();
        byte[] otidData = new byte[gtrid.length];
        System.arraycopy(gtrid, 0, otidData, 0, gtrid.length);
        otid_t otid = new otid_t(this.xid.getFormatId(), 0, otidData);
        return otid;
    }

    public OTSResource getCORBAObjReference() {
        if (this.thisRef == null) {
            if (Configuration.getORB() == null) {
                return this;
            }
            if (poa == null) {
                poa = Configuration.getPOA("transient");
            }
            try {
                poa.activate_object((Servant)this);
                this.thisRef = OTSResourceHelper.narrow(poa.servant_to_reference((Servant)this));
            }
            catch (Exception exc) {
                _logger.log(Level.SEVERE, "jts.create_xaresource_object_error", exc);
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.create_xaresource_object_error");
                throw new INTERNAL(msg);
            }
        }
        return this.thisRef;
    }

    public final String toString() {
        return new String("OTSResource : XAResource " + this.xaRes + " XID " + this.xid);
    }

    private void destroy() {
        if (poa != null && this.thisRef != null) {
            try {
                poa.deactivate_object(poa.reference_to_id((Object)this.thisRef));
                this.thisRef = null;
            }
            catch (Exception exc) {
                _logger.log(Level.WARNING, "jts.object_destroy_error", "OTSResource");
            }
        }
    }

    private void ensureInitialized() {
    }

    public Object _duplicate() {
        throw no_implement;
    }

    public void _release() {
        throw no_implement;
    }

    public boolean _is_a(String repository_id) {
        throw no_implement;
    }

    public boolean _is_equivalent(Object that) {
        throw no_implement;
    }

    public boolean _non_existent() {
        throw no_implement;
    }

    public int _hash(int maximum) {
        throw no_implement;
    }

    public Request _request(String operation) {
        throw no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        throw no_implement;
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        throw no_implement;
    }

    public Object _get_interface_def() {
        throw no_implement;
    }

    public Policy _get_policy(int policy_type) {
        throw no_implement;
    }

    public DomainManager[] _get_domain_managers() {
        throw no_implement;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        throw no_implement;
    }
}

