/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.serverbeans.TransactionService;
import com.sun.enterprise.transaction.api.ResourceRecoveryManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.jta.TransactionManagerImpl;
import com.sun.jts.utils.RecoveryHooks.FailureInducer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.types.Property;

public class TransactionServiceProperties {
    private static Logger _logger = LogDomains.getLogger(TransactionServiceProperties.class, (String)"javax.enterprise.system.core.transaction");
    private static StringManager localStrings = StringManager.getManager(TransactionServiceProperties.class);
    private static final String JTS_XA_SERVER_NAME = "com.sun.jts.xa-servername";
    private static final String J2EE_SERVER_ID_PROP = "com.sun.enterprise.J2EEServerId";
    private static final String JTS_SERVER_ID = "com.sun.jts.persistentServerId";
    private static final String HABITAT = "HABITAT";
    private static final int DEFAULT_SERVER_ID = 100;
    private static Properties properties = null;
    private static volatile boolean orbAvailable = false;
    private static volatile boolean recoveryInitialized = false;

    public static synchronized Properties getJTSProperties(Habitat habitat, boolean isORBAvailable) {
        if (orbAvailable == isORBAvailable && properties != null) {
            return properties;
        }
        Properties jtsProperties = new Properties();
        if (habitat != null) {
            TransactionService txnService;
            jtsProperties.put(HABITAT, habitat);
            ProcessEnvironment processEnv = (ProcessEnvironment)habitat.getComponent(ProcessEnvironment.class);
            if (processEnv.getProcessType().isServer() && (txnService = (TransactionService)habitat.getComponent(TransactionService.class)) != null) {
                boolean isAutomaticRecovery;
                jtsProperties.put("com.sun.jts.heuristicDirection", txnService.getHeuristicDecision());
                jtsProperties.put("com.sun.jts.keypointCount", txnService.getKeypointInterval());
                String automaticRecovery = txnService.getAutomaticRecovery();
                boolean bl = isAutomaticRecovery = TransactionServiceProperties.isValueSet(automaticRecovery) && "true".equals(automaticRecovery);
                if (isAutomaticRecovery) {
                    _logger.log(Level.FINE, "Recoverable J2EE Server");
                    jtsProperties.put("com.sun.jts.ManualRecovery", "true");
                }
                boolean disable_distributed_transaction_logging = false;
                String dbLoggingResource = null;
                for (Property prop : txnService.getProperty()) {
                    String name = prop.getName();
                    String value = prop.getValue();
                    if (name.equals("disable-distributed-transaction-logging")) {
                        if (!TransactionServiceProperties.isValueSet(value) || !"true".equals(value)) continue;
                        disable_distributed_transaction_logging = true;
                        continue;
                    }
                    if (name.equals("xaresource-txn-timeout")) {
                        if (!TransactionServiceProperties.isValueSet(value)) continue;
                        _logger.log(Level.FINE, "XAResource transaction timeout is" + value);
                        TransactionManagerImpl.setXAResourceTimeOut(Integer.parseInt(value));
                        continue;
                    }
                    if (name.equals("db-logging-resource")) {
                        dbLoggingResource = value;
                        _logger.log(Level.FINE, "Transaction DB Logging Resource Name" + dbLoggingResource);
                        if (dbLoggingResource == null || !" ".equals(dbLoggingResource) && !"".equals(dbLoggingResource)) continue;
                        dbLoggingResource = "jdbc/TxnDS";
                        continue;
                    }
                    if (name.equals("xa-servername")) {
                        if (!TransactionServiceProperties.isValueSet(value)) continue;
                        jtsProperties.put(JTS_XA_SERVER_NAME, value);
                        continue;
                    }
                    if (name.equals("pending-txn-cleanup-interval")) {
                        if (!TransactionServiceProperties.isValueSet(value)) continue;
                        jtsProperties.put("pending-txn-cleanup-interval", value);
                        continue;
                    }
                    if (!name.equals("add-wait-point-during-recovery") || !TransactionServiceProperties.isValueSet(value)) continue;
                    try {
                        FailureInducer.setWaitPointRecovery(Integer.parseInt(value));
                    }
                    catch (Exception e) {
                        _logger.log(Level.WARNING, e.getMessage());
                    }
                }
                if (dbLoggingResource != null) {
                    disable_distributed_transaction_logging = true;
                    jtsProperties.put("com.sun.jts.logResource", dbLoggingResource);
                }
                int jtsServerId = 100;
                if (isORBAvailable && (jtsServerId = ((GlassFishORBHelper)habitat.getComponent(GlassFishORBHelper.class)).getORBInitialPort()) == 0) {
                    jtsServerId = 100;
                }
                jtsProperties.put(JTS_SERVER_ID, String.valueOf(jtsServerId));
                String serverId = String.valueOf(100);
                System.setProperty(J2EE_SERVER_ID_PROP, serverId);
                if (!isAutomaticRecovery && disable_distributed_transaction_logging) {
                    Configuration.disableFileLogging();
                }
                ServerContext ctx = (ServerContext)habitat.getByContract(ServerContext.class);
                String instanceName = ctx.getInstanceName();
                if (dbLoggingResource == null) {
                    Cluster cluster;
                    Domain domain = (Domain)habitat.getComponent(Domain.class);
                    Server server = domain.getServerNamed(instanceName);
                    String logdir = TransactionServiceProperties.getTXLogDir((SystemPropertyBag)server);
                    if (logdir == null && (cluster = server.getCluster()) != null) {
                        logdir = TransactionServiceProperties.getTXLogDir((SystemPropertyBag)cluster);
                    }
                    if (logdir == null) {
                        logdir = txnService.getTxLogDir();
                    }
                    if (logdir == null) {
                        logdir = domain.getLogRoot();
                        if (logdir == null) {
                            logdir = ".." + File.separator + "logs";
                        }
                    } else if (!new File(logdir).isAbsolute()) {
                        String logroot;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Relative pathname specified for transaction log directory : " + logdir);
                        }
                        logdir = (logroot = domain.getLogRoot()) != null ? logroot + File.separator + logdir : ".." + File.separator + "logs" + File.separator + logdir;
                    }
                    logdir = logdir + File.separator + instanceName + File.separator + "tx";
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "JTS log directory: " + logdir);
                        _logger.log(Level.FINE, "JTS Server id " + jtsServerId);
                    }
                    new File(logdir).mkdirs();
                    jtsProperties.put("com.sun.jts.logDirectory", logdir);
                }
                jtsProperties.put("com.sun.jts.commitRetry", txnService.getRetryTimeoutInSeconds());
                jtsProperties.put("com.sun.jts.instancename", instanceName);
            }
        }
        properties = jtsProperties;
        orbAvailable = isORBAvailable;
        return properties;
    }

    public static void initRecovery(boolean force) {
        if (recoveryInitialized) {
            return;
        }
        if (properties == null) {
            if (force) {
                _logger.log(Level.WARNING, "", new IllegalStateException());
            }
            return;
        }
        String value = properties.getProperty("com.sun.jts.ManualRecovery");
        if (force || TransactionServiceProperties.isValueSet(value) && "true".equals(value)) {
            recoveryInitialized = true;
            Habitat habitat = (Habitat)properties.get(HABITAT);
            if (habitat != null) {
                ProcessEnvironment processEnv = (ProcessEnvironment)habitat.getComponent(ProcessEnvironment.class);
                if (processEnv.getProcessType().isServer()) {
                    value = properties.getProperty("pending-txn-cleanup-interval");
                    int interval = -1;
                    if (TransactionServiceProperties.isValueSet(value)) {
                        interval = Integer.parseInt(value);
                    }
                    new RecoveryHelperThread(habitat, interval).start();
                }
                RecoveryManager.startResyncThread();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[JTS] Started ResyncThread");
                }
            }
        }
    }

    private static boolean isValueSet(String value) {
        return value != null && !value.equals("") && !value.equals(" ");
    }

    private static String getTXLogDir(SystemPropertyBag bag) {
        for (SystemProperty prop : bag.getSystemProperty()) {
            String name = prop.getName();
            if (!name.equals("TX-LOG-DIR")) continue;
            return prop.getValue();
        }
        return null;
    }

    private static class RecoveryHelperThread
    extends Thread {
        private int interval;
        private Habitat habitat;

        RecoveryHelperThread(Habitat habitat, int interval) {
            this.setName("Recovery Helper Thread");
            this.setDaemon(true);
            this.habitat = habitat;
            this.interval = interval;
        }

        public void run() {
            ResourceRecoveryManager recoveryManager = (ResourceRecoveryManager)this.habitat.getByContract(ResourceRecoveryManager.class);
            if (this.interval <= 0) {
                return;
            }
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "Asynchronous thread for incomplete tx is enabled with interval " + this.interval);
            }
            int prevSize = 0;
            try {
                while (true) {
                    Thread.sleep((long)this.interval * 1000L);
                    if (!RecoveryManager.isIncompleteTxRecoveryRequired().booleanValue()) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, "Incomplete transaction recovery is not requeired,  waiting for the next interval");
                        continue;
                    }
                    if (RecoveryManager.sizeOfInCompleTx() <= prevSize) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, "Incomplete transaction recovery is not required,  waiting for the next interval SIZE");
                        continue;
                    }
                    prevSize = RecoveryManager.sizeOfInCompleTx();
                    recoveryManager.recoverIncompleteTx(false, null);
                }
            }
            catch (Exception ex) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, " Exception occurred in recoverInCompleteTx ");
                }
                return;
            }
        }
    }
}

