/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorTerm;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Request;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.StatusHolder;
import org.omg.CosTransactions.Terminator;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TerminatorPOA;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.Servant;

class TerminatorImpl
extends TerminatorPOA
implements Terminator {
    private static POA poa = null;
    private Terminator thisRef = null;
    CoordinatorTerm coordTerm = null;
    ControlImpl control = null;
    static Logger _logger = LogDomains.getLogger(TerminatorImpl.class, (String)"javax.enterprise.system.core.transaction");

    TerminatorImpl() {
    }

    TerminatorImpl(CoordinatorImpl coordinator, boolean subtran) {
        this.coordTerm = new CoordinatorTerm(coordinator, subtran);
    }

    void setControl(ControlImpl control) {
        this.control = control;
    }

    private void PreCompletionCheck() throws TRANSACTION_ROLLEDBACK, INVALID_TRANSACTION {
        StatusHolder status = new StatusHolder();
        this.control.getLocalTID(status);
        if (status.value != Status.StatusActive) {
            if (status.value == Status.StatusRolledBack) {
                TRANSACTION_ROLLEDBACK exc = new TRANSACTION_ROLLEDBACK(0, CompletionStatus.COMPLETED_NO);
                throw exc;
            }
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(3, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
        if (this.control.isOutgoing()) {
            INVALID_TRANSACTION exc = new INVALID_TRANSACTION(2, CompletionStatus.COMPLETED_NO);
            throw exc;
        }
    }

    public synchronized void commit(boolean reportHeuristics) throws HeuristicMixed, HeuristicHazard, TRANSACTION_ROLLEDBACK {
        this.PreCompletionCheck();
        try {
            this.coordTerm.commit(!reportHeuristics);
        }
        catch (HeuristicMixed exc) {
            if (reportHeuristics) {
                this.control.destroy();
                throw exc;
            }
        }
        catch (HeuristicHazard exc) {
            if (reportHeuristics) {
                this.control.destroy();
                throw exc;
            }
        }
        catch (TRANSACTION_ROLLEDBACK exc) {
            this.control.destroy();
            throw exc;
        }
        catch (LogicErrorException exc) {
            this.control.destroy();
            INTERNAL ex2 = new INTERNAL(262, CompletionStatus.COMPLETED_NO);
            throw ex2;
        }
        catch (INTERNAL exc) {
            this.control.destroy();
            throw exc;
        }
        this.control.destroy();
    }

    public void rollback() throws SystemException {
        this.PreCompletionCheck();
        try {
            this.coordTerm.rollback();
        }
        catch (HeuristicMixed exc) {
            this.control.destroy();
        }
        catch (HeuristicHazard exc) {
            this.control.destroy();
        }
        catch (TRANSACTION_ROLLEDBACK exc) {
            this.control.destroy();
            throw exc;
        }
        catch (LogicErrorException exc) {
            this.control.destroy();
            INTERNAL ex2 = new INTERNAL(262, CompletionStatus.COMPLETED_NO);
            throw ex2;
        }
        catch (INTERNAL exc) {
            this.control.destroy();
            throw exc;
        }
        this.control.destroy();
    }

    final synchronized Terminator object() {
        if (this.thisRef == null) {
            if (poa == null) {
                poa = Configuration.getPOA("transient");
            }
            try {
                poa.activate_object((Servant)this);
                this.thisRef = TerminatorHelper.narrow((Object)poa.servant_to_reference((Servant)this));
            }
            catch (ServantAlreadyActive saexc) {
                _logger.log(Level.SEVERE, "jts.create_terminator_object_error", saexc);
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.create_terminator_object_error");
                throw new INTERNAL(msg);
            }
            catch (ServantNotActive snexc) {
                _logger.log(Level.SEVERE, "jts.create_terminator_object_error", snexc);
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.create_terminator_object_error");
                throw new INTERNAL(msg);
            }
            catch (Exception exc) {
                _logger.log(Level.SEVERE, "jts.create_terminator_object_error", exc);
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.create_terminator_object_error");
                throw new INTERNAL(msg);
            }
        }
        return this.thisRef;
    }

    final synchronized void destroy() {
        if (poa != null && this.thisRef != null) {
            try {
                poa.deactivate_object(poa.reference_to_id((Object)this.thisRef));
                this.thisRef = null;
            }
            catch (Exception exc) {
                _logger.log(Level.WARNING, "jts.object_destroy_error", "Terminator");
            }
        }
    }

    public Object _duplicate() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public void _release() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _is_a(String repository_id) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _is_equivalent(Object that) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public boolean _non_existent() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public int _hash(int maximum) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _request(String operation) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Object _get_interface_def() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Policy _get_policy(int policy_type) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public DomainManager[] _get_domain_managers() {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType set_add) {
        throw new NO_IMPLEMENT("This is a locally constrained object.");
    }
}

