/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.utils.RecoveryHooks;

import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.codegen.otsidl.JCoordinator;
import com.sun.jts.codegen.otsidl.JCoordinatorHelper;
import com.sun.jts.jtsxa.Utility;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.Coordinator;

public class FailureInducer {
    public static final Integer ACTIVE = new Integer(0);
    public static final Integer PREPARING = new Integer(1);
    public static final Integer PREPARED = new Integer(2);
    public static final Integer COMPLETING = new Integer(3);
    public static final Integer COMPLETED = new Integer(4);
    private static boolean failureInducerIsActive = false;
    private static boolean crash = false;
    private static int waitPeriod = 0;
    private static int waitCount = 0;
    private static int recoveryWaitDuration = 0;
    private static Hashtable crashList = new Hashtable();
    private static Hashtable waitList = new Hashtable();
    private static Hashtable waitTime = new Hashtable();
    private static ResourceBundle messages = ResourceBundle.getBundle("com.sun.jts.utils.RecoveryHooks.Messages");
    static Logger _logger = LogDomains.getLogger(FailureInducer.class, (String)"javax.enterprise.system.core.transaction");

    public static void activateFailureInducer() {
        failureInducerIsActive = true;
    }

    public static void deactivateFailureInducer() {
        failureInducerIsActive = false;
    }

    public static boolean isFailureInducerActive() {
        return failureInducerIsActive;
    }

    public static void setCrashPoint(Integer crashPoint) {
        if (crashPoint == null) {
            _logger.log(Level.SEVERE, "jts.invalid_crash_point");
            return;
        }
        GlobalTID gtid = FailureInducer.getGlobalTID();
        if (gtid != null) {
            crashList.put(gtid, crashPoint);
        }
    }

    public static void setWaitPoint(Integer waitPoint, int waitDuration) {
        if (waitPoint == null) {
            _logger.log(Level.SEVERE, "jts.invalid_wait_point");
            return;
        }
        GlobalTID gtid = FailureInducer.getGlobalTID();
        if (gtid != null) {
            waitList.put(gtid, waitPoint);
            waitTime.put(gtid, new Integer(waitDuration));
        }
    }

    public static void crash() {
        crash = true;
    }

    private static void incrementWaitCount() {
        ++waitCount;
    }

    public static int getWaitCount() {
        return waitCount;
    }

    public static void waitForFailure(GlobalTID gtid, Integer failPoint) {
        if (gtid == null) {
            return;
        }
        Integer crashPoint = (Integer)crashList.get(gtid);
        Integer waitPoint = (Integer)waitList.get(gtid);
        if (crashPoint == null && waitPoint == null) {
            return;
        }
        _logger.log(Level.WARNING, "jts.failpoint", failPoint);
        if (crashPoint != null && crashPoint.equals(failPoint)) {
            FailureInducer.incrementWaitCount();
            while (!crash) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Exception e) {}
            }
            System.exit(0);
        }
        if (waitPoint != null && waitPoint.equals(failPoint)) {
            Integer waitDuration = (Integer)waitTime.get(gtid);
            if (waitDuration == null || waitDuration < 0) {
                return;
            }
            try {
                Thread.sleep((long)waitDuration.intValue() * 1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void setWaitPointRecovery(int waitDuration) {
        recoveryWaitDuration = waitDuration;
    }

    public static void waitInRecovery() {
        if (recoveryWaitDuration > 0) {
            _logger.log(Level.WARNING, "jts.failpoint", "RECOVERY");
            try {
                Thread.sleep((long)recoveryWaitDuration * 1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String getMessage(String key) {
        return FailureInducer.getMessage(key, null);
    }

    private static String getMessage(String key, java.lang.Object[] inserts) {
        if (messages == null || key == null) {
            return null;
        }
        String msg = messages.getString(key);
        if (msg == null) {
            return null;
        }
        if (inserts == null) {
            return msg;
        }
        return MessageFormat.format(msg, inserts);
    }

    private static GlobalTID getGlobalTID() {
        GlobalTID gtid = null;
        Coordinator coord = Utility.getCoordinator(Utility.getControl());
        JCoordinator jcoord = JCoordinatorHelper.narrow((Object)coord);
        if (jcoord != null) {
            gtid = new GlobalTID(jcoord.getGlobalTID());
        } else {
            ControlImpl control = CurrentTransaction.getCurrent();
            if (control != null) {
                gtid = control.getGlobalTID();
            }
        }
        return gtid;
    }
}

