/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.CurrentImpl;
import com.sun.jts.CosTransactions.CurrentTransaction;
import com.sun.jts.CosTransactions.DefaultTransactionService;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.RecoveryManager;
import com.sun.jts.CosTransactions.XATerminatorImpl;
import com.sun.jts.codegen.otsidl.JControlHelper;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jta.TransactionServiceProperties;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.Xid;
import org.glassfish.internal.api.Globals;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.CurrentHelper;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Unavailable;

public class TransactionManagerImpl
implements TransactionManager {
    private static TransactionManagerImpl tm;
    private Current current;
    private static HashMap statusMap;
    private static int[] directLookup;
    static final int maxStatus;
    static Logger _logger;
    private static int xaTimeOut;
    private static Status[] CosTransactionStatus;
    private static int[] JTAStatus;

    public static synchronized TransactionManagerImpl getTransactionManagerImpl() {
        if (tm == null) {
            tm = new TransactionManagerImpl();
        }
        return tm;
    }

    private TransactionManagerImpl() {
        try {
            ORB orb = Configuration.getORB();
            if (orb != null) {
                this.current = CurrentHelper.narrow((Object)orb.resolve_initial_references("TransactionCurrent"));
            } else {
                DefaultTransactionService dts = new DefaultTransactionService();
                Properties p = TransactionServiceProperties.getJTSProperties(Globals.getDefaultHabitat(), false);
                dts.identify_ORB(null, null, p);
                this.current = dts.get_current();
            }
            TransactionServiceProperties.initRecovery(true);
        }
        catch (InvalidName inex) {
            _logger.log(Level.SEVERE, "jts.unexpected_error_in_create_transaction_manager", inex);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "jts.unexpected_error_in_create_transaction_manager", ex);
        }
    }

    public static void initJTSProperties(Properties props, String logDir, boolean trace, String traceDir) {
        if (traceDir == null) {
            traceDir = ".";
        }
        if (logDir == null) {
            logDir = ".";
        }
        props.put("com.sun.corba.se.CosTransactions.ORBJTSClass", "com.sun.jts.CosTransactions.DefaultTransactionService");
        props.put("com.sun.jts.traceDirectory", traceDir);
        props.put("com.sun.jts.logDirectory", logDir);
        if (trace) {
            props.put("com.sun.jts.trace", "true");
        }
    }

    public static int mapStatus(Status status) {
        int statusVal = status.value();
        if (statusVal < 0 || statusVal > maxStatus) {
            return 5;
        }
        return directLookup[statusVal];
    }

    public void begin() throws NotSupportedException, SystemException {
        try {
            if (this.current.get_control() != null) {
                throw new NotSupportedException();
            }
            this.current.begin();
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new NotSupportedException();
        }
        catch (SubtransactionsUnavailable ex) {
            throw new SystemException();
        }
    }

    public void begin(int timeout) throws NotSupportedException, SystemException {
        try {
            if (this.current.get_control() != null) {
                throw new NotSupportedException();
            }
            ((CurrentImpl)this.current).begin(timeout);
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new NotSupportedException();
        }
        catch (SubtransactionsUnavailable ex) {
            throw new SystemException();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.current.commit(true);
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new RollbackException();
        }
        catch (NoTransaction ex) {
            throw new IllegalStateException();
        }
        catch (NO_PERMISSION ex) {
            throw new SecurityException();
        }
        catch (HeuristicMixed ex) {
            throw new HeuristicMixedException();
        }
        catch (HeuristicHazard ex) {
            throw new HeuristicRollbackException();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.current.rollback();
        }
        catch (NoTransaction ex) {
            throw new IllegalStateException();
        }
        catch (NO_PERMISSION ex) {
            throw new SecurityException();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        try {
            this.current.rollback_only();
        }
        catch (NoTransaction ex) {
            throw new IllegalStateException();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public int getStatus() throws SystemException {
        try {
            Status status = this.current.get_status();
            return TransactionManagerImpl.mapStatus(status);
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public synchronized void setTransactionTimeout(int seconds) throws SystemException {
        try {
            if (seconds < 0) {
                String msg = LogFormatter.getLocalizedMessage(_logger, "jts.invalid_timeout");
                throw new SystemException(msg);
            }
            this.current.set_timeout(seconds);
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public Transaction getTransaction() throws SystemException {
        try {
            Control control = this.current.get_control();
            if (control == null) {
                return null;
            }
            return this.createTransactionImpl(control);
        }
        catch (Unavailable uex) {
            throw new SystemException(uex.toString());
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public void resume(Transaction suspended) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this.getTransaction() != null) {
            throw new IllegalStateException();
        }
        if (suspended == null) {
            throw new InvalidTransactionException();
        }
        if (!(suspended instanceof TransactionImpl)) {
            throw new InvalidTransactionException();
        }
        Control control = ((TransactionImpl)suspended).getControl();
        try {
            this.current.resume(control);
        }
        catch (InvalidControl ex) {
            throw new InvalidTransactionException();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    public Transaction suspend() throws SystemException {
        try {
            Control control = this.current.suspend();
            if (control == null) {
                return null;
            }
            return this.createTransactionImpl(control);
        }
        catch (Unavailable uex) {
            throw new SystemException(uex.toString());
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    private Transaction createTransactionImpl(Control control) throws Unavailable, SystemException {
        GlobalTID gtid = null;
        if (Configuration.isLocalFactory()) {
            gtid = ((ControlImpl)control).getGlobalTID();
        } else {
            ControlImpl cntrlImpl = ControlImpl.servant(JControlHelper.narrow((Object)control));
            gtid = cntrlImpl.getGlobalTID();
        }
        return new TransactionImpl(control, gtid);
    }

    public static void recover(Enumeration xaResourceList) {
        RecoveryManager.recoverXAResources(xaResourceList);
    }

    public static void recreate(Xid xid, long timeout) throws WorkException {
        if (xid == null || xid.getFormatId() == 0 || xid.getBranchQualifier() == null || xid.getGlobalTransactionId() == null) {
            WorkCompletedException workExc = new WorkCompletedException("Invalid Xid");
            workExc.setErrorCode("3");
            throw workExc;
        }
        if (!DefaultTransactionService.isActive()) {
            WorkCompletedException workExc = new WorkCompletedException("Transaction Manager unavailable");
            workExc.setErrorCode("3");
            throw workExc;
        }
        GlobalTID tid = new GlobalTID(xid);
        try {
            CurrentTransaction.recreate(tid, (int)(timeout <= 0L ? 0L : timeout));
        }
        catch (Throwable exc) {
            String errorCode = "3";
            if (exc instanceof INVALID_TRANSACTION && ((INVALID_TRANSACTION)exc).minor == 267) {
                errorCode = "2";
            }
            WorkCompletedException workExc = new WorkCompletedException(exc);
            workExc.setErrorCode(errorCode);
            throw workExc;
        }
    }

    public static void release(Xid xid) throws WorkException {
        GlobalTID tid = new GlobalTID(xid);
        try {
            CurrentTransaction.release(tid);
        }
        catch (Throwable exc) {
            String errorCode = "0";
            if (exc instanceof INTERNAL) {
                errorCode = "-1";
            }
            WorkCompletedException workExc = new WorkCompletedException(exc);
            workExc.setErrorCode(errorCode);
            throw workExc;
        }
    }

    public static XATerminator getXATerminator() {
        return new XATerminatorImpl();
    }

    public static void setXAResourceTimeOut(int value) {
        xaTimeOut = value;
    }

    public static int getXAResourceTimeOut() {
        return xaTimeOut;
    }

    static {
        int i;
        tm = null;
        _logger = LogDomains.getLogger(TransactionManagerImpl.class, (String)"javax.enterprise.system.core.transaction");
        xaTimeOut = 0;
        CosTransactionStatus = new Status[]{Status.StatusActive, Status.StatusMarkedRollback, Status.StatusPrepared, Status.StatusCommitted, Status.StatusRolledBack, Status.StatusUnknown, Status.StatusNoTransaction, Status.StatusPreparing, Status.StatusCommitting, Status.StatusRollingBack};
        JTAStatus = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        statusMap = new HashMap();
        int calcMaxStatus = 0;
        for (i = 0; i < CosTransactionStatus.length; ++i) {
            statusMap.put(CosTransactionStatus[i], JTAStatus[i]);
            calcMaxStatus = Math.max(calcMaxStatus, CosTransactionStatus[i].value());
        }
        maxStatus = calcMaxStatus;
        directLookup = new int[maxStatus + 1];
        for (i = 0; i < directLookup.length; ++i) {
            TransactionManagerImpl.directLookup[i] = 5;
        }
        for (i = 0; i < CosTransactionStatus.length; ++i) {
            int statusVal = CosTransactionStatus[i].value();
            if (statusVal < 0) {
                _logger.log(Level.SEVERE, "A negative CosTransaction Status value was detected.");
                continue;
            }
            TransactionManagerImpl.directLookup[statusVal] = JTAStatus[i];
        }
    }
}

