/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.Service;
import com.sun.enterprise.admin.servermgmt.services.ServiceFactory;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.Vector;

public class CreateServiceCommand
extends AbstractCommand {
    private static final String DOMAIN_PARENT_DIR = "domaindir";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String SERVICE_PROPERTIES = "serviceproperties";
    private static final String VALID_TYPES = "das|node-agent";
    private static final String DAS_TYPE = "das";
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateServiceCommand.class);
    private static final CLILogger logger = CLILogger.getInstance();
    private File serverDir;
    private String serviceName;
    private File passwordFile;
    private File asadminScript;
    private File serverDirParent;
    private String serverName;

    public void runCommand() throws CommandException, CommandValidationException {
        try {
            this.validateOptions();
            boolean dry_run = this.getBooleanOption("dry-run");
            String type = DAS_TYPE;
            Service service = ServiceFactory.getService();
            service.setDate(new Date().toString());
            service.setName(this.serviceName);
            service.setDryRun(dry_run);
            service.setLocation(this.serverDir.getPath());
            service.setType(type.equals(DAS_TYPE) ? AppserverServiceType.Domain : AppserverServiceType.NodeAgent);
            service.setFQSN();
            service.setOSUser();
            service.setAsadminPath(this.asadminScript.getPath());
            if (this.passwordFile != null) {
                service.setPasswordFilePath(this.passwordFile.getPath());
            }
            service.setServiceProperties(this.getOption(SERVICE_PROPERTIES));
            service.isConfigValid();
            service.setTrace(CLILogger.isDebug());
            service.createService(service.tokensAndValues());
            CLILogger.getInstance().printMessage(service.getSuccessMessage());
            logger.printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (CommandValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandValidationException((Throwable)e);
        }
    }

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        this.validateServerDir();
        this.validateName();
        this.validateAsadmin();
        this.validatePasswordFile();
        return true;
    }

    private void validateServerDir() throws CommandValidationException {
        String serverDirParentPath;
        Vector v = this.getOperands();
        if (v.size() >= 1) {
            this.serverName = (String)v.get(0);
        }
        this.serverDirParent = !CreateServiceCommand.ok(serverDirParentPath = this.getOption(DOMAIN_PARENT_DIR)) ? this.getDefaultServerDirParent() : SmartFile.sanitize((File)new File(serverDirParentPath));
        if (!this.serverDirParent.isDirectory()) {
            throw new CommandValidationException(strings.get("create.service.BadServerDirParent", new Object[]{this.serverDirParent}));
        }
        if (!CreateServiceCommand.ok(this.serverName)) {
            this.serverName = this.getTheOneAndOnlyDomain();
        }
        this.serverDir = SmartFile.sanitize((File)new File(this.serverDirParent, this.serverName));
        if (!this.serverDir.isDirectory()) {
            throw new CommandValidationException(strings.get("create.service.BadServerDir", new Object[]{this.serverDir}));
        }
    }

    private File getDefaultServerDirParent() {
        String ir = System.getProperty("com.sun.aas.installRoot");
        if (!CreateServiceCommand.ok(ir)) {
            throw new RuntimeException("Internal Error: System Property not set: com.sun.aas.installRoot");
        }
        return SmartFile.sanitize((File)new File(new File(ir), "domains"));
    }

    private String getTheOneAndOnlyDomain() {
        File[] files = this.serverDirParent.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f != null && f.isDirectory();
            }
        });
        if (files == null || files.length == 0) {
            throw new RuntimeException(strings.get("create.service.noServerDirs", new Object[]{this.serverDirParent}));
        }
        if (files.length > 1) {
            throw new RuntimeException(strings.get("create.service.tooManyDomainDirs", new Object[]{this.serverDirParent}));
        }
        return files[0].getName();
    }

    private void validateName() {
        this.serviceName = this.getOption(NAME);
        if (!CreateServiceCommand.ok(this.serviceName)) {
            this.serviceName = this.serverDir.getName();
        }
        logger.printDebugMessage("service name = " + this.serviceName);
    }

    private void validatePasswordFile() throws CommandValidationException {
        String passwordFileName = this.getOption("passwordfile");
        if (!CreateServiceCommand.ok(passwordFileName)) {
            return;
        }
        this.passwordFile = SmartFile.sanitize((File)new File(passwordFileName));
        if (!this.passwordFile.isFile()) {
            String msg = strings.get("create.service.NoSuchFile", new Object[]{passwordFileName});
            throw new CommandValidationException(msg);
        }
    }

    private void validateAsadmin() throws CommandValidationException {
        String s = SystemPropertyConstants.getAsAdminScriptLocation();
        if (!CreateServiceCommand.ok(s)) {
            throw new CommandValidationException(strings.get("internal.error", new Object[]{"Can't get Asadmin script location"}));
        }
        this.asadminScript = SmartFile.sanitize((File)new File(s));
        if (!this.asadminScript.isFile()) {
            throw new CommandValidationException(strings.get("create.service.noAsadminScript", new Object[]{this.asadminScript}));
        }
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

