/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.admin.rest.provider.StringListResult;
import org.glassfish.api.ActionReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionLeafResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected List<String> entity;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectionLeafResource.class);
    private ResourceUtil __resourceUtil = new ResourceUtil();

    public void setEntity(List<String> p) {
        this.entity = p;
    }

    public List<String> getEntity() {
        return this.entity;
    }

    @GET
    @Produces(value={"text/html", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    public StringListResult get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return new StringListResult(this.getName(), this.getEntity(), this.getPostCommand(), this.getDeleteCommand(), this.options());
    }

    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response create(HashMap<String, String> data) {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
            return this.delete(data);
        }
        return this.runCommand(this.getPostCommand(), data, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
    }

    @DELETE
    @Produces(value={"text/html"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response delete(HashMap<String, String> data) {
        return this.runCommand(this.getDeleteCommand(), data, "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(this.__resourceUtil.getResourceName(this.uriInfo));
        try {
            String deleteCommand;
            optionsResult.putMethodMetaData("GET", new MethodMetaData());
            String postCommand = this.getPostCommand();
            if (postCommand != null) {
                MethodMetaData postMethodMetaData = this.__resourceUtil.getMethodMetaData(postCommand, RestService.getHabitat(), RestService.logger);
                postMethodMetaData.setDescription("Create");
                optionsResult.putMethodMetaData("POST", postMethodMetaData);
            }
            if ((deleteCommand = this.getDeleteCommand()) != null) {
                MethodMetaData deleteMethodMetaData = this.__resourceUtil.getMethodMetaData(deleteCommand, RestService.getHabitat(), RestService.logger);
                deleteMethodMetaData.setDescription("Delete");
                optionsResult.putMethodMetaData("DELETE", deleteMethodMetaData);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }

    private void addDefaultParameter(HashMap<String, String> data) {
        int index = this.uriInfo.getAbsolutePath().getPath().lastIndexOf(47);
        String defaultParameterValue = this.uriInfo.getAbsolutePath().getPath().substring(index + 1);
        data.put("DEFAULT", defaultParameterValue);
    }

    protected String getPostCommand() {
        return null;
    }

    protected String getDeleteCommand() {
        return null;
    }

    protected String getName() {
        ResourceUtil resourceUtil = new ResourceUtil();
        return resourceUtil.getResourceName(this.uriInfo);
    }

    private Response runCommand(String commandName, HashMap<String, String> data, String successMsgKey, String successMsg, String operationForbiddenMsgKey, String operationForbiddenMsg) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return this.__resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            this.__resourceUtil.purgeEmptyEntries(data);
            this.__resourceUtil.adjustParameters(data);
            String attributeName = data.get("DEFAULT");
            if (null != commandName) {
                ActionReport actionReport = this.__resourceUtil.runCommand(commandName, data, RestService.getHabitat());
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode == ActionReport.ExitCode.SUCCESS) {
                    String successMessage = localStrings.getLocalString(successMsgKey, successMsg, new Object[]{attributeName});
                    return this.__resourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = this.getErrorMessage(data, actionReport);
                return this.__resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            String message = localStrings.getLocalString(operationForbiddenMsgKey, operationForbiddenMsg, new Object[]{this.uriInfo.getAbsolutePath()});
            return this.__resourceUtil.getResponse(403, message, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getErrorMessage(HashMap<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }
}

