/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.provider.CommandResourceGetResult;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.api.ActionReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCommandPostResource {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ResourceUtil.class);
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    private String resourceName;
    private String commandName;
    private String commandDisplayName;
    private String commandMethod;
    private String commandAction;
    private HashMap<String, String> commandParams = null;
    private boolean isLinkedToParent = false;
    private ResourceUtil resourceUtil = new ResourceUtil();

    public TemplateCommandPostResource(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, HashMap<String, String> m, boolean b) {
        this.resourceName = resourceName;
        this.commandName = commandName;
        this.commandMethod = commandMethod;
        this.commandAction = commandAction;
        this.commandDisplayName = commandDisplayName;
        this.commandParams = m;
        this.isLinkedToParent = b;
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response executeCommand(HashMap<String, String> data) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return this.resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            if (this.commandParams != null) {
                if (this.isLinkedToParent) {
                    this.resourceUtil.resolveParentParamValue(this.commandParams, this.uriInfo);
                }
                data.putAll(this.commandParams);
            }
            this.resourceUtil.adjustParameters(data);
            this.resourceUtil.purgeEmptyEntries(data);
            ActionReport actionReport = this.resourceUtil.runCommand(this.commandName, data, RestService.getHabitat());
            ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
            if (exitCode == ActionReport.ExitCode.SUCCESS) {
                String successMessage = localStrings.getLocalString("rest.request.success.message", "{0} of {1} executed successfully.", new Object[]{this.commandMethod, this.uriInfo.getAbsolutePath()});
                return this.resourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
            }
            String errorMessage = actionReport.getMessage();
            return this.resourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    public Response executeCommand() {
        try {
            return this.executeCommand(new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    public CommandResourceGetResult get() {
        try {
            return new CommandResourceGetResult(this.resourceName, this.commandName, this.commandDisplayName, this.commandMethod, this.commandAction, this.options());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(this.resourceName);
        try {
            MethodMetaData methodMetaData = this.resourceUtil.getMethodMetaData(this.commandName, this.commandParams, 1, RestService.getHabitat(), RestService.logger);
            optionsResult.putMethodMetaData("GET", new MethodMetaData());
            optionsResult.putMethodMetaData(this.commandMethod, methodMetaData);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }
}

