/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil
extends Util {
    static final Pattern TOKENIZER;

    public void adjustParameters(HashMap<String, String> data) {
        boolean isRenamed;
        if (data != null && !data.containsKey("DEFAULT") && !(isRenamed = this.renameParameter(data, "name", "DEFAULT"))) {
            this.renameParameter(data, "id", "DEFAULT");
        }
    }

    public void defineDefaultParameters(HashMap<String, String> data) {
        if (data != null && !data.containsKey("DEFAULT")) {
            this.renameParameter(data, "id", "DEFAULT");
        }
    }

    public String getCommand(RestRedirect.OpType type, ConfigBean configBean) {
        Class<?> cbp = null;
        try {
            cbp = ((ClassLoader)configBean.model.classLoaderHolder.get()).loadClass(configBean.model.targetTypeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
        if (restRedirects != null) {
            RestRedirect[] values;
            for (RestRedirect r : values = restRedirects.value()) {
                if (!r.opType().equals((Object)type)) continue;
                return r.commandName();
            }
        }
        return null;
    }

    public ActionReport runCommand(String commandName, HashMap<String, String> parameters, Habitat habitat) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        ActionReport ar = (ActionReport)habitat.getComponent(ActionReport.class);
        ParameterMap p = new ParameterMap();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            p.set((Object)entry.getKey(), (Object)entry.getValue());
        }
        cr.getCommandInvocation(commandName, ar).parameters(p).execute();
        return ar;
    }

    public ActionReport runCommand(String commandName, Properties parameters, Habitat habitat) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        ActionReport ar = (ActionReport)habitat.getComponent(ActionReport.class);
        ParameterMap p = new ParameterMap();
        for (String prop : parameters.stringPropertyNames()) {
            p.set((Object)prop, (Object)parameters.getProperty(prop));
        }
        cr.getCommandInvocation(commandName, ar).parameters(p).execute();
        return ar;
    }

    public MethodMetaData getMethodMetaData(String command, Habitat habitat, Logger logger) {
        return this.getMethodMetaData(command, 1, habitat, logger);
    }

    public MethodMetaData getMethodMetaData(String command, int pamameterType, Habitat habitat, Logger logger) {
        return this.getMethodMetaData(command, null, pamameterType, habitat, logger);
    }

    public MethodMetaData getMethodMetaData(String command, HashMap<String, String> commandParamsToSkip, int parameterType, Habitat habitat, Logger logger) {
        MethodMetaData methodMetaData = new MethodMetaData();
        if (command != null) {
            Collection<CommandModel.ParamModel> params = commandParamsToSkip == null ? this.getParamMetaData(command, habitat, logger) : this.getParamMetaData(command, commandParamsToSkip.keySet(), habitat, logger);
            for (CommandModel.ParamModel paramModel : params) {
                Param param = paramModel.getParam();
                ParameterMetaData parameterMetaData = this.getParameterMetaData(paramModel);
                String parameterName = param.primary() ? "id" : paramModel.getName();
                String alias = param.alias();
                if (alias != null && !alias.isEmpty()) {
                    parameterName = alias;
                }
                if (parameterType == 0) {
                    methodMetaData.putQureyParamMetaData(parameterName, parameterMetaData);
                    continue;
                }
                methodMetaData.putParameterMetaData(parameterName, parameterMetaData);
            }
        }
        return methodMetaData;
    }

    public void resolveParentParamValue(HashMap<String, String> commandParams, UriInfo uriInfo) {
        String parent = this.getParentName(uriInfo);
        if (parent != null) {
            Set<String> keys = commandParams.keySet();
            for (String key : keys) {
                if (!commandParams.get(key).equals("$parent")) continue;
                commandParams.put(key, parent);
                break;
            }
        }
    }

    public MethodMetaData getMethodMetaData(ConfigBean configBean) {
        return this.getMethodMetaData(configBean, 1);
    }

    public MethodMetaData getMethodMetaData(ConfigBean configBean, int parameterType) {
        MethodMetaData methodMetaData = new MethodMetaData();
        if (configBean != null) {
            Class<?> configBeanProxy = null;
            try {
                configBeanProxy = ((ClassLoader)configBean.model.classLoaderHolder.get()).loadClass(configBean.model.targetTypeName);
                Set attributeNames = configBean.model.getAttributeNames();
                for (String attributeName : attributeNames) {
                    String methodName = this.getAttributeMethodName(attributeName);
                    try {
                        Method method = configBeanProxy.getMethod(methodName, new Class[0]);
                        Attribute attribute = method.getAnnotation(Attribute.class);
                        if (attribute == null) continue;
                        ParameterMetaData parameterMetaData = this.getParameterMetaData(attribute);
                        attributeName = this.eleminateHypen(attributeName);
                        if (parameterType == 0) {
                            methodMetaData.putQureyParamMetaData(attributeName, parameterMetaData);
                            continue;
                        }
                        methodMetaData.putParameterMetaData(attributeName, parameterMetaData);
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return methodMetaData;
    }

    public Collection<CommandModel.ParamModel> getParamMetaData(String commandName, Habitat habitat, Logger logger) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection params = cm.getParameters();
        return params;
    }

    public Collection<CommandModel.ParamModel> getParamMetaData(String commandName, Collection<String> commandParamsToSkip, Habitat habitat, Logger logger) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection parameterNames = cm.getParametersNames();
        ArrayList<CommandModel.ParamModel> metaData = new ArrayList<CommandModel.ParamModel>();
        for (String name : parameterNames) {
            CommandModel.ParamModel paramModel = cm.getModelFor(name);
            String parameterName = paramModel.getParam().primary() ? "id" : paramModel.getName();
            boolean skipParameter = false;
            try {
                skipParameter = commandParamsToSkip.contains(parameterName);
            }
            catch (Exception e) {
                String errorMessage = localStrings.getLocalString("rest.metadata.skip.error", "Parameter \"{0}\" may be redundant and not required.", new Object[]{parameterName});
                Logger.getLogger(ResourceUtil.class.getName()).log(Level.INFO, null, errorMessage);
                Logger.getLogger(ResourceUtil.class.getName()).log(Level.INFO, null, e);
            }
            if (skipParameter) continue;
            metaData.add(paramModel);
        }
        return metaData;
    }

    public void purgeEmptyEntries(HashMap<String, String> data) {
        Set<String> keys = data.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (data.get(key) != null && data.get(key).length() >= 1) continue;
            data.remove(key);
            iterator = keys.iterator();
        }
    }

    public Response getResponse(int status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (this.isBrowser(requestHeaders)) {
            message = this.getHtml(message, uriInfo);
        }
        return Response.status((int)status).entity((Object)message).build();
    }

    public String getMessage(ActionReport actionReport) {
        String message = "";
        if (actionReport != null && (message = actionReport.getMessage()) == null) {
            message = "";
            boolean first = true;
            for (ActionReport.MessagePart mp : actionReport.getTopMessagePart().getChildren()) {
                if (!first) {
                    message = message + ", ";
                }
                message = message + mp.getMessage();
                first = false;
            }
        }
        return message;
    }

    private ParameterMetaData getParameterMetaData(CommandModel.ParamModel paramModel) {
        Param param = paramModel.getParam();
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("type", this.getXsdType(paramModel.getType().toString()));
        parameterMetaData.putAttribute("optional", Boolean.toString(param.optional()));
        parameterMetaData.putAttribute("defaultValue", param.defaultValue());
        parameterMetaData.putAttribute("acceptableValues", param.acceptableValues());
        return parameterMetaData;
    }

    private ParameterMetaData getParameterMetaData(Attribute attribute) {
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("type", this.getXsdType(attribute.dataType().toString()));
        parameterMetaData.putAttribute("optional", Boolean.toString(!attribute.required()));
        if (!attribute.defaultValue().equals("\u0000")) {
            parameterMetaData.putAttribute("defaultValue", attribute.defaultValue());
        }
        parameterMetaData.putAttribute("key", Boolean.toString(attribute.key()));
        return parameterMetaData;
    }

    private boolean renameParameter(HashMap<String, String> data, String parameterToRename, String newName) {
        if (data.containsKey(parameterToRename)) {
            String value = data.get(parameterToRename);
            data.remove(parameterToRename);
            data.put(newName, value);
            return true;
        }
        return false;
    }

    private void print(Collection<CommandModel.ParamModel> params) {
        for (CommandModel.ParamModel pm : params) {
            System.out.println("Command Param: " + pm.getName());
            System.out.println("Command Param Type: " + pm.getType());
            System.out.println("Command Param Name: " + pm.getParam().name());
            System.out.println("Command Param Shortname: " + pm.getParam().shortName());
        }
    }

    private boolean isBrowser(HttpHeaders requestHeaders) {
        boolean isClientAcceptsHtml = false;
        MediaType media = requestHeaders.getMediaType();
        List acceptHeaders = requestHeaders.getRequestHeader("Accept");
        for (String header : acceptHeaders) {
            if (!header.contains("text/html")) continue;
            isClientAcceptsHtml = true;
            break;
        }
        return media != null && media.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && isClientAcceptsHtml;
    }

    private String getXsdType(String javaType) {
        if (javaType.indexOf("java.lang.String") != -1) {
            return "string";
        }
        if (javaType.indexOf("java.lang.Boolean") != -1) {
            return "boolean";
        }
        if (javaType.indexOf("java.lang.Integer") != -1) {
            return "int";
        }
        if (javaType.indexOf("java.util.Properties") != -1) {
            return "string";
        }
        return javaType;
    }

    private String getAttributeMethodName(String attributeName) {
        return this.methodNameFromDtdName(attributeName, "get");
    }

    public HashMap<String, String> translateCamelCasedNamesToCommandParamNames(HashMap<String, String> sourceMap, String commandName, Habitat habitat, Logger logger) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection paramModels = cm.getParameters();
        HashMap<String, String> translatedMap = new HashMap<String, String>();
        for (CommandModel.ParamModel paramModel : paramModels) {
            Param param = paramModel.getParam();
            String camelCaseName = param.alias();
            if (!sourceMap.containsKey(camelCaseName)) continue;
            String paramValue = sourceMap.remove(camelCaseName);
            translatedMap.put(paramModel.getName(), paramValue);
        }
        translatedMap.putAll(sourceMap);
        return translatedMap;
    }

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    public static String convertToXMLName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    public static HashMap<String, String> translateCamelCasedNamesToXMLNames(Map<String, String> sourceData) {
        HashMap<String, String> convertedData = new HashMap<String, String>(sourceData.size());
        for (Map.Entry<String, String> entry : sourceData.entrySet()) {
            String camelCasedKeyName = entry.getKey();
            String xmlKeyName = ResourceUtil.convertToXMLName(camelCasedKeyName);
            convertedData.put(xmlKeyName, entry.getValue());
        }
        return convertedData;
    }

    static {
        String pattern = ResourceUtil.or(ResourceUtil.split("x", "X"), ResourceUtil.split("X", "Xx"), ResourceUtil.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
    }
}

