/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.admin.rest.provider.InputException;
import org.glassfish.admin.rest.provider.InputObject;
import org.glassfish.admin.rest.provider.JsonInputReader;

public class JsonInputObject
extends InputObject {
    private JsonInputReader jsonReader;

    public JsonInputObject(InputStream inputstream) throws InputException, IOException {
        this(JsonInputObject.readAsString(inputstream));
    }

    public JsonInputObject(String source) throws InputException {
        this(new JsonInputReader(source));
    }

    public JsonInputObject(JsonInputReader jsonReader) throws InputException {
        this.jsonReader = jsonReader;
        this.map = new HashMap();
    }

    public Map initializeMap() throws InputException {
        String key = null;
        if (this.jsonReader.nextNonSpace() != '{') {
            if (this.jsonReader.nextNonSpace() == '\u0000') {
                return new HashMap();
            }
            throw this.jsonReader.error("A JSON text must begin with '{'");
        }
        block8: while (true) {
            char c = this.jsonReader.nextNonSpace();
            switch (c) {
                case '\u0000': {
                    throw this.jsonReader.error("A JSON text must end with '}'");
                }
                case '}': {
                    return this.map;
                }
            }
            this.jsonReader.back();
            key = this.jsonReader.nextValue().toString();
            c = this.jsonReader.nextNonSpace();
            if (c != ':') {
                throw this.jsonReader.error("Expected a ':' after a key");
            }
            Object value = this.jsonReader.nextValue();
            if (value instanceof JsonInputObject) {
                JsonInputObject jsonObject = (JsonInputObject)value;
                this.map.putAll(jsonObject.initializeMap());
            } else {
                this.put(key, value);
            }
            switch (this.jsonReader.nextNonSpace()) {
                case ',': {
                    if (this.jsonReader.nextNonSpace() == '}') {
                        return this.map;
                    }
                    this.jsonReader.back();
                    continue block8;
                }
                case '}': {
                    return this.map;
                }
            }
            break;
        }
        throw this.jsonReader.error("Expected a ',' or '}'");
    }
}

