/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml"})
public class TreeNodeXmlProvider
extends ProviderUtil
implements MessageBodyWriter<List<TreeNode>> {
    @Context
    protected UriInfo uriInfo;

    public long getSize(List<TreeNode> proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if ("java.util.List<org.glassfish.flashlight.datatree.TreeNode>".equals(genericType.toString())) {
            return mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE);
        }
        return false;
    }

    public void writeTo(List<TreeNode> proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getXml(proxy).getBytes());
    }

    private String getXml(List<TreeNode> proxy) {
        String attributes;
        String typeKey = this.getTypeKey(this.getName(this.uriInfo.getPath(), '/'));
        String result = "<" + typeKey;
        if (proxy.isEmpty() && this.uriInfo.getPath().equalsIgnoreCase("domain")) {
            result = result + TreeNodeXmlProvider.getHint(this.uriInfo, "application/xml");
        }
        if ((attributes = this.getAttributes(proxy)) != null && attributes.length() > 0) {
            result = result + attributes;
        }
        result = result + this.getResourcesLinks(proxy);
        result = result + TreeNodeXmlProvider.getEndXmlElement(typeKey);
        return result;
    }

    private String getAttributes(List<TreeNode> nodeList) {
        String result = "";
        for (TreeNode node : nodeList) {
            String value;
            if (node.hasChildNodes() || (value = this.xmlForPrimitiveValue(node.getValue())).length() <= 0) continue;
            result = result + " " + node.getName() + "=" + TreeNodeXmlProvider.quote(this.xmlForPrimitiveValue(node.getValue()));
        }
        result = result + ">" + "\n\n";
        for (TreeNode node : nodeList) {
            if (node.hasChildNodes()) continue;
            result = result + this.xmlForStatisticValue(node.getValue());
        }
        return result;
    }

    private String getResourcesLinks(List<TreeNode> nodeList) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) continue;
            try {
                result = result + "  ";
                result = result + TreeNodeXmlProvider.getStartXmlElement(TreeNodeXmlProvider.getResourceKey().replace(' ', '-'));
                String elementName = node.getName();
                result = result + TreeNodeXmlProvider.getElementLink(this.uriInfo, elementName);
                result = result + TreeNodeXmlProvider.getEndXmlElement(TreeNodeXmlProvider.getResourceKey().replace(' ', '-'));
                result = result + "\n";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (result.length() > 1) {
            result = result + "\n";
        }
        return result;
    }

    private String xmlForPrimitiveValue(Object value) {
        String result = "";
        if (value != null && !(value instanceof Statistic) && !(value instanceof Stats)) {
            result = value.toString();
        }
        return result;
    }

    private String xmlForStatisticValue(Object value) {
        String result = "";
        if (value == null) {
            return result;
        }
        try {
            if (value instanceof Statistic) {
                Statistic statisticObject = (Statistic)value;
                result = result + this.getStatisticRepresentation(statisticObject);
            } else if (value instanceof Stats) {
                for (Statistic statistic : ((Stats)value).getStatistics()) {
                    String statResult = this.getStatisticRepresentation(statistic);
                    if (statResult.equals("")) continue;
                    result = result + statResult;
                    statResult = "";
                }
            }
            return result;
        }
        catch (Exception exception) {
            return result;
        }
    }

    private String getStatisticRepresentation(Statistic statistic) throws IllegalAccessException, InvocationTargetException {
        String result = "";
        Map<String, Object> map = TreeNodeXmlProvider.getStatistic(statistic);
        Set<String> attributes = map.keySet();
        result = result + "  ";
        result = result + "<" + statistic.getName().replace('/', '_');
        for (String attributeName : attributes) {
            Object attributeValue = map.get(attributeName);
            result = " " + result + " " + attributeName + "=" + TreeNodeXmlProvider.quote(attributeValue.toString());
        }
        result = result + ">";
        result = result + TreeNodeXmlProvider.getEndXmlElement(statistic.getName().replace('/', '_'));
        result = result + "\n\n";
        return result;
    }
}

