/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.admin.rest.CollectionLeafResource;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="__list-targets")
@Scoped(value=PerLookup.class)
public class ListTargetsCommand
implements AdminCommand {
    @Inject
    Domain domain;
    @Param(primary=true, acceptableValues="das,instance,cluster,server")
    String type;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectionLeafResource.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfTargets = 0;
        List lcontainers = this.domain.getAllReferenceContainers();
        for (ReferenceContainer rc : lcontainers) {
            ActionReport.MessagePart childPart;
            if ("das".equals(this.type)) {
                if (!rc.isDas()) continue;
                childPart = part.addChild();
                childPart.setMessage(rc.getReference());
                ++numOfTargets;
                continue;
            }
            if ("instance".equals(this.type)) {
                if (!rc.isInstance()) continue;
                childPart = part.addChild();
                childPart.setMessage(rc.getReference());
                ++numOfTargets;
                continue;
            }
            if ("cluster".equals(this.type)) {
                if (!rc.isCluster()) continue;
                childPart = part.addChild();
                childPart.setMessage(rc.getReference());
                ++numOfTargets;
                continue;
            }
            if ("server".equals(this.type)) {
                if (!rc.isServer()) continue;
                childPart = part.addChild();
                childPart.setMessage(rc.getReference());
                ++numOfTargets;
                continue;
            }
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage("operand should be either 'das' or 'server' or 'intance' or 'cluster'");
            return;
        }
        if (numOfTargets == 0) {
            part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
        }
    }
}

