/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml"})
public class OptionsResultXmlProvider
extends ProviderUtil
implements MessageBodyWriter<OptionsResult> {
    @Context
    protected UriInfo uriInfo;
    private static final String QUERY_PARAMETERS = "queryParameters";
    private static final String MESSAGE_PARAMETERS = "messageParameters";
    private static final String METHOD = "method";

    public long getSize(OptionsResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(OptionsResult.class);
    }

    public void writeTo(OptionsResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getXml(proxy).getBytes());
    }

    private String getXml(OptionsResult proxy) {
        String indent = "  ";
        String result = "<" + proxy.getName() + ">";
        result = result + this.getRespresenationForMethodMetaData(proxy, indent);
        result = result + "\n" + OptionsResultXmlProvider.getEndXmlElement(proxy.getName());
        return result;
    }

    String getRespresenationForMethodMetaData(OptionsResult proxy, String indent) {
        String result = "";
        Set<String> methods = proxy.methods();
        for (String method : methods) {
            result = result + this.getMethod(method, indent);
            MethodMetaData methodMetaData = proxy.getMethodMetaData(method);
            result = result + this.getQueryParams(methodMetaData, indent + "  ");
            result = result + this.getMessageParams(methodMetaData, indent + "  ");
            result = result + "\n" + indent;
            result = result + OptionsResultXmlProvider.getEndXmlElement(METHOD);
        }
        return result;
    }

    private String getMethod(String method, String indent) {
        String result = "\n" + indent + "<";
        result = result + METHOD + " name=";
        result = result + OptionsResultXmlProvider.quote(method);
        result = result + ">";
        return result;
    }

    private String getQueryParams(MethodMetaData methodMetaData, String indent) {
        String result = "";
        if (methodMetaData.sizeQueryParamMetaData() > 0) {
            result = result + "\n" + indent;
            result = result + "<" + QUERY_PARAMETERS + ">";
            Set<String> queryParams = methodMetaData.queryParams();
            for (String queryParam : queryParams) {
                ParameterMetaData parameterMetaData = methodMetaData.getQureyParamMetaData(queryParam);
                result = result + this.getParameter(queryParam, parameterMetaData, indent + "  ");
            }
            result = result + "\n" + indent;
            result = result + OptionsResultXmlProvider.getEndXmlElement(QUERY_PARAMETERS);
        }
        return result;
    }

    private String getMessageParams(MethodMetaData methodMetaData, String indent) {
        String result = "";
        if (methodMetaData.sizeParameterMetaData() > 0) {
            result = result + "\n" + indent;
            result = result + "<" + MESSAGE_PARAMETERS + ">";
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result = result + this.getParameter(parameter, parameterMetaData, indent + "  ");
            }
            result = result + "\n" + indent;
            result = result + OptionsResultXmlProvider.getEndXmlElement(MESSAGE_PARAMETERS);
        }
        return result;
    }

    private String getParameter(String parameter, ParameterMetaData parameterMetaData, String indent) {
        String result = "\n" + indent;
        result = result + "<" + parameter;
        Set<String> attributes = parameterMetaData.attributes();
        for (String attributeName : attributes) {
            String attributeValue = parameterMetaData.getAttributeValue(attributeName);
            result = result + this.getAttribute(attributeName, attributeValue);
        }
        result = result + "/>";
        return result;
    }

    private String getAttribute(String name, String value) {
        String result = " ";
        name = name.replace(' ', '-');
        result = result + name + "=" + OptionsResultXmlProvider.quote(value);
        return result;
    }
}

