/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.provider.StringResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class StringResultHtmlProvider
extends ProviderUtil
implements MessageBodyWriter<StringResult> {
    @Context
    protected UriInfo uriInfo;

    public long getSize(StringResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            if (Class.forName("org.glassfish.admin.rest.provider.StringResult").equals(genericType)) {
                return mediaType.isCompatible(MediaType.TEXT_HTML_TYPE);
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public void writeTo(StringResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getHtml(proxy).getBytes());
    }

    private String getHtml(StringResult proxy) {
        String result = StringResultHtmlProvider.getHtmlHeader();
        String uri = this.uriInfo.getAbsolutePath().toString();
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String parentName = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getParentName(uri)));
        result = result + "<h1>" + name + "</h1>";
        if (proxy.isError()) {
            result = result + "<h2>Error:</h2>";
            result = result + proxy.getErrorMessage() + "<br>";
        } else {
            result = result + "<h2>" + parentName + " - " + name + "</h2>";
            result = result + proxy.getMessage() + "<br>";
        }
        result = "<div>" + result + "</div>" + "<br>";
        result = result + "</body></html>";
        return result;
    }
}

