/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import org.glassfish.api.Startup;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.internal.api.LocalPassword;
import org.glassfish.internal.api.RestInterfaceUID;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;

@Service
public class RestService
implements Startup,
PostConstruct,
PreDestroy,
RestInterfaceUID {
    @Inject
    private static Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    MonitoringRuntimeDataRegistry monitoringRegistry;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    LocalPassword localPassword;
    private static String logLocation;
    private static Domain theDomain;
    private static MonitoringRuntimeDataRegistry theMonitoringRegistry;
    private static ConfigSupport configSupport;
    public static final Logger logger;
    public static final LocalStringManagerImpl localStrings;
    private static String _uid;

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public static Habitat getHabitat() {
        return habitat;
    }

    public static ConfigSupport getConfigSupport() {
        return configSupport;
    }

    public static Domain getDomain() {
        return theDomain;
    }

    public static ConfigBean getDomainBean() {
        Dom dom1 = Dom.unwrap((ConfigBeanProxy)RestService.getDomain());
        Dom root = dom1.document.getRoot();
        return (ConfigBean)root;
    }

    public static MonitoringRuntimeDataRegistry getMonitoringRegistry() {
        return theMonitoringRegistry;
    }

    public static String getLogLocation() {
        return logLocation;
    }

    public void postConstruct() {
        logger.fine(localStrings.getLocalString("rest.service.initialization", "Initializing REST interface support"));
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void preDestroy() {
    }

    public String getUID() {
        if (_uid == null) {
            _uid = this.localPassword.getLocalPassword();
        }
        return _uid;
    }

    static String getRestUID() {
        return _uid;
    }

    private void initialize() throws Exception {
        ConfigSupport cs;
        theDomain = this.domain;
        logLocation = (String)this.env.getProps().get("com.sun.aas.instanceRoot") + "/logs/server.log";
        theMonitoringRegistry = this.monitoringRegistry;
        configSupport = cs = (ConfigSupport)habitat.getComponent(ConfigSupport.class);
    }

    static {
        logger = LogDomains.getLogger(RestService.class, (String)"javax.enterprise.system.tools.admin");
        localStrings = new LocalStringManagerImpl(RestService.class);
    }
}

