/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.jersey.spi.container.ContainerRequest;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.TemplateExecCommand;
import org.glassfish.admin.rest.provider.CommandResourceGetResult;
import org.glassfish.api.ActionReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCommandDeleteResource
extends TemplateExecCommand {
    public TemplateCommandDeleteResource(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, HashMap<String, String> m, boolean b) {
        super(resourceName, commandName, commandMethod, commandAction, commandDisplayName, m, b);
        this.parameterType = 1;
    }

    @DELETE
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response executeCommand(HashMap<String, String> data) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            if (this.commandParams != null) {
                if (this.isLinkedToParent) {
                    ResourceUtil.resolveParentParamValue(this.commandParams, this.uriInfo);
                }
                data.putAll(this.commandParams);
            }
            ResourceUtil.addQueryString((MultivaluedMap<String, String>)((ContainerRequest)this.requestHeaders).getQueryParameters(), data);
            ResourceUtil.adjustParameters(data);
            ResourceUtil.purgeEmptyEntries(data);
            String typeOfResult = ((MediaType)this.requestHeaders.getAcceptableMediaTypes().get(0)).getSubtype();
            ActionReport actionReport = ResourceUtil.runCommand(this.commandName, data, RestService.getHabitat(), typeOfResult);
            ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
            if (exitCode == ActionReport.ExitCode.SUCCESS) {
                String successMessage = localStrings.getLocalString("rest.request.success.message", "{0} of {1} executed successfully.", new Object[]{this.commandMethod, this.uriInfo.getAbsolutePath()});
                return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
            }
            String errorMessage = actionReport.getMessage();
            return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    public Response executeCommand() {
        try {
            return this.executeCommand(new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response hack(HashMap<String, String> data) {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
        }
        return this.executeCommand(data);
    }

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    public CommandResourceGetResult get() {
        try {
            return new CommandResourceGetResult(this.resourceName, this.commandName, this.commandDisplayName, this.commandMethod, this.commandAction, this.options());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

