/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.TemplateResource;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.GetResultList;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateListOfResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateListOfResource.class);

    @GET
    @Produces(value={"text/html", "application/json", "application/xml"})
    public GetResultList get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        ArrayList<Dom> domList = new ArrayList<Dom>();
        List<Dom> entities = this.getEntity();
        if (entities == null) {
            return new GetResultList(domList, this.getPostCommand(), this.getCommandResourcesPaths(), this.options());
        }
        for (ConfigBean configBean : entities) {
            domList.add((Dom)configBean);
        }
        return new GetResultList(domList, this.getPostCommand(), this.getCommandResourcesPaths(), this.options());
    }

    public void setEntity(List<Dom> p) {
        this.entity = p;
    }

    public List<Dom> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.nodeElements(tagName);
    }

    @POST
    @Produces(value={"text/html"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response CreateResource(HashMap<String, String> data) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            ResourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            ResourceUtil.adjustParameters(data);
            String resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + data.get("DEFAULT");
            if (null != commandName) {
                String typeOfResult = ((MediaType)this.requestHeaders.getAcceptableMediaTypes().get(0)).getSubtype();
                ActionReport actionReport = ResourceUtil.runCommand(commandName, data, RestService.getHabitat(), typeOfResult);
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode == ActionReport.ExitCode.SUCCESS) {
                    String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
                    return ResourceUtil.getResponse(201, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = this.getErrorMessage(data, actionReport);
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            Class<? extends ConfigBeanProxy> proxy = TemplateListOfResource.getElementTypeByName(this.parent, this.tagName);
            ConfigSupport.createAndSet((ConfigBean)((ConfigBean)this.parent), proxy, data);
            String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
            return ResourceUtil.getResponse(201, successMessage, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public static Class<? extends ConfigBeanProxy> getElementTypeByName(Dom parentDom, String elementName) throws ClassNotFoundException {
        DomDocument document = parentDom.document;
        ConfigModel.Property a = parentDom.model.getElement(elementName);
        if (a != null) {
            if (a.isLeaf()) {
                return null;
            }
            ConfigModel childModel = ((ConfigModel.Node)a).getModel();
            return ((ClassLoader)childModel.classLoaderHolder.get()).loadClass(childModel.targetTypeName);
        }
        ConfigModel model = document.getModelByElementName(elementName);
        if (model != null) {
            return ((ClassLoader)model.classLoaderHolder.get()).loadClass(model.targetTypeName);
        }
        return null;
    }

    private Response CreateResource(HashMap<String, String> data, String resourceToCreate) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            ResourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            ResourceUtil.defineDefaultParameters(data);
            if (resourceToCreate == null || resourceToCreate.equals("")) {
                String newResourceName = data.get("DEFAULT");
                if (newResourceName.contains("/")) {
                    newResourceName = Util.getName(newResourceName, '/');
                } else if (newResourceName.contains("\\")) {
                    newResourceName = Util.getName(newResourceName, '\\');
                }
                resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + newResourceName;
            } else {
                resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + resourceToCreate;
            }
            if (null != commandName) {
                String typeOfResult = ((MediaType)this.requestHeaders.getAcceptableMediaTypes().get(0)).getSubtype();
                ActionReport actionReport = ResourceUtil.runCommand(commandName, data, RestService.getHabitat(), typeOfResult);
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode == ActionReport.ExitCode.SUCCESS) {
                    String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
                    return ResourceUtil.getResponse(201, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = this.getErrorMessage(data, actionReport);
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            String message = localStrings.getLocalString("rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.", new Object[]{resourceToCreate});
            return ResourceUtil.getResponse(403, message, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        HashMap<String, String> data = TemplateResource.createDataBasedOnForm(formData);
        return this.CreateResource(data, data.get("name"));
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        try {
            optionsResult.putMethodMetaData("GET", new MethodMetaData());
            String command = this.getPostCommand();
            if (command != null) {
                MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(command, RestService.getHabitat(), RestService.logger);
                postMethodMetaData.setDescription("Create");
                if (Util.getResourceName(this.uriInfo).equals("Application")) {
                    postMethodMetaData.setIsFileUploadOperation(true);
                }
                optionsResult.putMethodMetaData("POST", postMethodMetaData);
            } else {
                ConfigModel.Node prop = (ConfigModel.Node)this.parent.model.getElement(this.tagName);
                if (prop == null) {
                    ConfigModel.Node prop2 = (ConfigModel.Node)this.parent.model.getElement("*");
                    ConfigModel childModel = prop2.getModel();
                    Class<?> subType = ((ClassLoader)childModel.classLoaderHolder.get()).loadClass(childModel.targetTypeName);
                    List lcm = this.parent.document.getAllModelsImplementing(subType);
                    if (lcm != null) {
                        for (ConfigModel cmodel : lcm) {
                            if (!cmodel.getTagName().equals(this.tagName)) continue;
                            MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData2(this.parent, cmodel, 1);
                            postMethodMetaData.setDescription("Update");
                            optionsResult.putMethodMetaData("POST", postMethodMetaData);
                        }
                    }
                } else {
                    MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData2(this.parent, prop.getModel(), 1);
                    postMethodMetaData.setDescription("Update");
                    optionsResult.putMethodMetaData("POST", postMethodMetaData);
                }
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }

    public abstract String getPostCommand();

    public String[][] getCommandResourcesPaths() {
        return new String[0][];
    }

    private String getErrorMessage(HashMap<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }
}

