/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class TreeNodeJsonProvider
extends ProviderUtil
implements MessageBodyWriter<List<TreeNode>> {
    @Context
    protected UriInfo uriInfo;

    public long getSize(List<TreeNode> proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if ("java.util.List<org.glassfish.flashlight.datatree.TreeNode>".equals(genericType.toString())) {
            return mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
        }
        return false;
    }

    public void writeTo(List<TreeNode> proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getJson(proxy).getBytes());
    }

    private String getJson(List<TreeNode> proxy) {
        String indent = "  ";
        String result = "{";
        result = result + "\n\n" + indent;
        result = result + TreeNodeJsonProvider.quote(this.getTypeKey(Util.getName(this.uriInfo.getPath(), '/'))) + ":{";
        if (proxy.isEmpty() && this.uriInfo.getPath().equalsIgnoreCase("domain")) {
            result = result + TreeNodeJsonProvider.getHint(this.uriInfo, "application/json");
        }
        result = result + this.getAttributes(proxy, indent + "  ");
        result = result + "},";
        result = result + "\n\n" + indent;
        result = result + TreeNodeJsonProvider.quote(TreeNodeJsonProvider.getResourcesKey());
        result = result + ":[";
        result = result + this.getResourcesLinks(proxy, indent + "  ");
        result = result + "\n" + indent + "]";
        result = result + "\n\n" + "}";
        return result;
    }

    private String getAttributes(List<TreeNode> nodeList, String indent) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (node.hasChildNodes()) continue;
            result = result + this.jsonForNodeValue(node.getName(), node.getValue(), indent);
        }
        int endIndex = result.length() - 1;
        if (endIndex > 0) {
            result = result.substring(0, endIndex);
        }
        return result;
    }

    private String getResourcesLinks(List<TreeNode> nodeList, String indent) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) continue;
            try {
                String elementName = node.getName();
                result = result + "\n" + indent;
                result = result + TreeNodeJsonProvider.quote(TreeNodeJsonProvider.getElementLink(this.uriInfo, elementName));
                result = result + ",";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int endIndex = result.length() - 1;
        if (endIndex > 0) {
            result = result.substring(0, endIndex);
        }
        return result;
    }

    private String jsonForNodeValue(String name, Object value, String indent) {
        String result = "";
        if (value == null) {
            return result;
        }
        try {
            if (value instanceof Statistic) {
                Statistic statisticObject = (Statistic)value;
                result = result + this.getStatisticRepresentation(statisticObject);
                result = "\n" + indent + TreeNodeJsonProvider.quote(name) + ":" + "{" + result + "}";
                result = result + ",";
                return result;
            }
            if (value instanceof Stats) {
                for (Statistic statistic : ((Stats)value).getStatistics()) {
                    String statResult = this.getStatisticRepresentation(statistic);
                    if (statResult.equals("")) continue;
                    statResult = "\n" + indent + indent + TreeNodeJsonProvider.quote(statistic.getName()) + ":" + "{" + statResult + "}";
                    result = result + statResult;
                    result = result + ",";
                    statResult = "";
                }
                int endIndex = result.length() - 1;
                if (endIndex > 0) {
                    result = result.substring(0, endIndex);
                }
                result = "\n" + indent + TreeNodeJsonProvider.quote(name) + ":" + "{" + result + "}";
                result = result + ",";
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = " " + TreeNodeJsonProvider.quote(name) + ":" + TreeNodeJsonProvider.jsonValue(value);
        result = result + ",";
        return result;
    }

    private String getStatisticRepresentation(Statistic statistic) throws IllegalAccessException, InvocationTargetException {
        String result = "";
        Map<String, Object> map = TreeNodeJsonProvider.getStatistic(statistic);
        Set<String> attributes = map.keySet();
        for (String attributeName : attributes) {
            Object attributeValue = map.get(attributeName);
            result = result + " " + TreeNodeJsonProvider.quote(attributeName) + ":" + TreeNodeJsonProvider.jsonValue(attributeValue);
            result = result + ",";
        }
        int endIndex = result.length() - 1;
        if (endIndex > 0) {
            result = result.substring(0, endIndex);
        }
        return result;
    }
}

