/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.admin.rest.provider.InputException;
import org.glassfish.admin.rest.provider.InputObject;
import org.glassfish.admin.rest.provider.XmlInputReader;

public class XmlInputObject
extends InputObject {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');
    private XmlInputReader xmlReader;

    public XmlInputObject(InputStream inputstream) throws InputException, IOException {
        this(XmlInputObject.readAsString(inputstream));
    }

    public XmlInputObject(String source) throws InputException {
        this(new XmlInputReader(source));
    }

    public XmlInputObject(XmlInputReader xmlReader) throws InputException {
        this.xmlReader = xmlReader;
        this.map = new HashMap();
    }

    public Map initializeMap() throws InputException {
        while (this.xmlReader.more() && this.xmlReader.skipPast("<")) {
            XmlInputObject.parse(this.xmlReader, this, null);
        }
        return this.map;
    }

    public Map getMap() throws InputException {
        return this.map;
    }

    private static boolean parse(XmlInputReader reader, XmlInputObject context, String name) throws InputException {
        String string;
        Object token = reader.nextToken();
        if (token == BANG) {
            char character = reader.next();
            if (character == '-') {
                if (reader.next() == '-') {
                    reader.skipPast("-->");
                    return false;
                }
                reader.back();
            } else if (character == '[') {
                token = reader.nextToken();
                if (token.equals("CDATA") && reader.next() == '[') {
                    String string2 = reader.nextCDATA();
                    if (string2.length() > 0) {
                        context.put("content", string2);
                    }
                    return false;
                }
                throw reader.error("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((token = reader.nextMeta()) == null) {
                    throw reader.error("Missing '>' after '<!'.");
                }
                if (token == LT) {
                    ++i;
                    continue;
                }
                if (token != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (token == QUEST) {
            reader.skipPast("?>");
            return false;
        }
        if (token == SLASH) {
            token = reader.nextToken();
            if (name == null) {
                throw reader.error("Mismatched close tag " + token);
            }
            if (!token.equals(name)) {
                throw reader.error("Mismatched " + name + " and " + token);
            }
            if (reader.nextToken() != GT) {
                throw reader.error("Misshaped close tag");
            }
            return true;
        }
        if (token instanceof Character) {
            throw reader.error("Misshaped tag");
        }
        String n = (String)token;
        token = null;
        XmlInputObject subContext = new XmlInputObject(reader);
        while (true) {
            if (token == null) {
                token = reader.nextToken();
            }
            if (!(token instanceof String)) break;
            string = (String)token;
            token = reader.nextToken();
            if (token == EQ) {
                token = reader.nextToken();
                if (!(token instanceof String)) {
                    throw reader.error("Missing value");
                }
                subContext.put(string, XmlInputObject.stringToValue((String)token));
                token = null;
                continue;
            }
            subContext.put(string, "");
        }
        if (token == SLASH) {
            if (reader.nextToken() != GT) {
                throw reader.error("Misshaped tag");
            }
            context.putMap(n, subContext.getMap());
            return false;
        }
        if (token == GT) {
            while (true) {
                if ((token = reader.nextContent()) == null) {
                    if (n != null) {
                        throw reader.error("Unclosed tag " + n);
                    }
                    return false;
                }
                if (token instanceof String) {
                    string = (String)token;
                    if (string.length() <= 0) continue;
                    subContext.put("content", XmlInputObject.stringToValue(string));
                    continue;
                }
                if (token == LT && XmlInputObject.parse(reader, subContext, n)) break;
            }
            if (subContext.length() == 0) {
                context.put(n, "");
            } else if (subContext.length() == 1 && subContext.get("content") != null) {
                context.put(n, subContext.get("content"));
            } else {
                context.putMap(n, subContext.getMap());
            }
            return false;
        }
        throw reader.error("Misshaped tag");
    }
}

