/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.AdminAdapter;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.http.Cookie;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;
import org.glassfish.admin.rest.LazyJerseyInit;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.SessionManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestAdapter
extends GrizzlyAdapter
implements org.glassfish.api.container.Adapter,
PostConstruct,
EventListener {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RestAdapter.class);
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    volatile AdminService as = null;
    @Inject
    Events events;
    @Inject
    Habitat habitat;
    @Inject(name="default-instance-name")
    Config config;
    CountDownLatch latch = new CountDownLatch(1);
    @Inject
    ServerContext sc;
    @Inject
    RestService restService;
    private Map<Integer, String> httpStatus = new HashMap<Integer, String>(){
        {
            this.put(404, "Resource not found");
            this.put(500, "A server error occurred. Please check the server logs.");
        }
    };
    private Adapter adapter = null;
    private boolean isRegistered = false;
    private AdminEndpointDecider epd = null;

    protected RestAdapter() {
        this.setAllowEncodedSlash(true);
    }

    public void postConstruct() {
        this.epd = new AdminEndpointDecider(this.config, this.logger);
        this.events.register((EventListener)this);
    }

    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        LogHelper.getDefaultLogger().finer("Rest monitoring adapter !");
        LogHelper.getDefaultLogger().finer("Received monitoring resource request: " + req.getRequestURI());
        String requestURI = req.getRequestURI();
        ActionReport report = this.getClientActionReport(requestURI, req);
        try {
            if (!this.latch.await(20L, TimeUnit.SECONDS)) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                String msg = localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait");
                report.setMessage(msg);
                this.reportError(res, report, 503);
                return;
            }
            if (!this.authenticate(req)) {
                String msg = localStrings.getLocalString("rest.adapter.auth.userpassword", "Invalid user name or password");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(msg);
                report.setActionDescription("Authentication error");
                res.setStatus(401);
                res.setHeader("WWW-Authenticate", "BASIC");
                res.setContentType(report.getContentType());
                report.writeReport((OutputStream)res.getOutputStream());
                res.getOutputStream().flush();
                res.finishResponse();
                return;
            }
            if (this.adapter == null) {
                this.exposeContext();
            }
            ((GrizzlyAdapter)this.adapter).service(req, res);
            int status = res.getStatus();
            if (status < 200 || status > 299) {
                String message = this.httpStatus.get(status);
                if (message == null) {
                    message = "Request returned " + status;
                }
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setMessage(message);
                this.reportError(res, report, status);
            }
        }
        catch (InterruptedException e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait");
            report.setMessage(msg);
            this.reportError(res, report, 503);
            return;
        }
        catch (IOException e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("rest.adapter.server.ioexception", "REST: IO Exception " + e.getLocalizedMessage());
            report.setMessage(msg);
            this.reportError(res, report, 503);
            return;
        }
        catch (LoginException e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("rest.adapter.auth.error", "Error authenticating");
            report.setMessage(msg);
            this.reportError(res, report, 401);
            return;
        }
        catch (Exception e) {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            e.printStackTrace(printWriter);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("rest.adapter.server.exception", "REST:  Exception " + result.toString());
            report.setMessage(msg);
            this.reportError(res, report, 503);
            return;
        }
    }

    private boolean authenticate(GrizzlyRequest req) throws LoginException, IOException {
        boolean authenticated = false;
        authenticated = this.authenticateViaLocalPassword(req);
        if (!authenticated) {
            authenticated = this.authenticateViaRestToken(req);
        }
        if (!authenticated) {
            authenticated = this.authenticateViaAdminRalm(req.getRequest());
        }
        return authenticated;
    }

    private boolean authenticateViaRestToken(GrizzlyRequest req) {
        boolean authenticated = false;
        Cookie[] cookies = req.getCookies();
        String restToken = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"gfresttoken".equals(cookie.getName())) continue;
                restToken = cookie.getValue();
            }
        }
        if (restToken != null) {
            authenticated = SessionManager.getSessionManager().authenticate(restToken);
        }
        return authenticated;
    }

    private boolean authenticateViaLocalPassword(GrizzlyRequest req) {
        Cookie[] cookies = req.getCookies();
        boolean authenticated = false;
        String uid = RestService.getRestUID();
        if (uid != null && cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("gfrestuid") || !cookie.getValue().equals(uid)) continue;
                authenticated = true;
                break;
            }
        }
        return authenticated;
    }

    private boolean authenticateViaAdminRalm(Request req) throws LoginException, IOException {
        String[] up = AdminAdapter.getUserPassword((Request)req);
        String user = up[0];
        String password = up.length > 1 ? up[1] : "";
        AdminAccessController authenticator = (AdminAccessController)this.habitat.getByContract(AdminAccessController.class);
        if (authenticator != null) {
            return authenticator.loginAsAdmin(user, password, this.as.getAuthRealmName());
        }
        return true;
    }

    public void afterService(GrizzlyRequest req, GrizzlyResponse res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.latch.countDown();
            this.logger.fine("Ready to receive REST resource requests");
        }
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public InetAddress getListenAddress() {
        return this.epd.getListenAddress();
    }

    public List<String> getVirtualServers() {
        return this.epd.getAsadminHosts();
    }

    protected abstract Set<Class<?>> getResourcesConfig();

    private ActionReport getClientActionReport(String requestURI, GrizzlyRequest req) {
        ActionReport report = null;
        if (requestURI.indexOf(46) != -1) {
            String qualifier = requestURI.substring(requestURI.indexOf(46) + 1);
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, qualifier);
        } else {
            String accept;
            String userAgent = req.getHeader("User-Agent");
            if (userAgent != null) {
                report = (ActionReport)this.habitat.getComponent(ActionReport.class, userAgent.substring(userAgent.indexOf(47) + 1));
            }
            if (report == null && (accept = req.getHeader("Accept")) != null) {
                StringTokenizer st = new StringTokenizer(accept, ",");
                while (report == null && st.hasMoreElements()) {
                    String scheme = st.nextToken();
                    report = (ActionReport)this.habitat.getComponent(ActionReport.class, scheme.substring(scheme.indexOf(47) + 1));
                }
            }
        }
        if (report == null) {
            report = (ActionReport)this.habitat.getComponent(ActionReport.class, "html");
        }
        report.setActionDescription("REST");
        return report;
    }

    private void exposeContext() throws EndpointRegistrationException {
        String context = this.getContextRoot();
        this.logger.fine("Exposing rest resource context root: " + context);
        if (context != null || !"".equals(context)) {
            Set<Class<?>> classes = this.getResourcesConfig();
            this.adapter = LazyJerseyInit.exposeContext(classes, this.sc);
            ((GrizzlyAdapter)this.adapter).setResourcesContextPath(context);
            this.logger.info("Listening to REST requests at context: " + context + "/domain");
        }
    }

    private void reportError(GrizzlyResponse res, ActionReport report, int statusCode) {
        try {
            res.setStatus(statusCode);
            res.setContentType(report.getContentType());
            report.writeReport((OutputStream)res.getOutputStream());
            res.getOutputStream().flush();
            res.finishResponse();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

