/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.TemplateExecCommand;
import org.glassfish.admin.rest.provider.ActionReportResult;
import org.glassfish.admin.rest.provider.CommandResourceGetResult;
import org.glassfish.api.ActionReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateCommandPostResource
extends TemplateExecCommand {
    public TemplateCommandPostResource(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, HashMap<String, String> m, boolean b) {
        super(resourceName, commandName, commandMethod, commandAction, commandDisplayName, m, b);
        this.parameterType = 1;
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult executeCommand(HashMap<String, String> data) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
            }
            if (this.commandParams != null) {
                if (this.isLinkedToParent) {
                    ResourceUtil.resolveParentParamValue(this.commandParams, this.uriInfo);
                }
                data.putAll(this.commandParams);
            }
            ResourceUtil.adjustParameters(data);
            ResourceUtil.purgeEmptyEntries(data);
            String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
            ActionReport actionReport = ResourceUtil.runCommand(this.commandName, data, RestService.getHabitat(), typeOfResult);
            ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
            ActionReportResult results = new ActionReportResult(this.commandName, actionReport, this.options());
            if (exitCode == ActionReport.ExitCode.SUCCESS) {
                results.setStatusCode(200);
            } else {
                results.setStatusCode(400);
                results.setIsError(true);
                results.setErrorMessage(actionReport.getMessage());
            }
            return results;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    public ActionReportResult executeCommand() {
        try {
            return this.executeCommand(new HashMap<String, String>());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    public CommandResourceGetResult get() {
        try {
            return new CommandResourceGetResult(this.resourceName, this.commandName, this.commandDisplayName, this.commandMethod, this.commandAction, this.options());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

