/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.logviewer;

import com.sun.enterprise.server.logging.logviewer.backend.LogFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.admin.rest.logviewer.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredLogViewerResource {
    @GET
    @Produces(value={"text/plain"})
    public String get(@QueryParam(value="logFileName") @DefaultValue(value="${com.sun.aas.instanceRoot}/logs/server.log") String logFileName, @QueryParam(value="startIndex") @DefaultValue(value="-1") long startIndex, @QueryParam(value="searchForward") @DefaultValue(value="false") boolean searchForward, @QueryParam(value="maximumNumberOfResults") @DefaultValue(value="40") int maximumNumberOfResults, @QueryParam(value="fromTime") @DefaultValue(value="-1") long fromTime, @QueryParam(value="toTime") @DefaultValue(value="-1") long toTime, @QueryParam(value="logLevel") @DefaultValue(value="INFO") String logLevel) throws IOException {
        LogFilter logFilter = new LogFilter();
        Properties props = new Properties();
        List moduleList = null;
        boolean sortAscending = true;
        if (!searchForward) {
            sortAscending = false;
        }
        AttributeList result = LogFilter.getLogRecordsUsingQuery((String)logFileName, (Long)startIndex, (Boolean)searchForward, (Boolean)sortAscending, (Integer)maximumNumberOfResults, (Date)(fromTime == -1L ? null : new Date(fromTime)), (Date)(toTime == -1L ? null : new Date(toTime)), (String)logLevel, (Boolean)true, moduleList, (Properties)props);
        return this.convertQueryResult(result);
    }

    private <T> List<T> asList(Object list) {
        return (List)List.class.cast(list);
    }

    private String quoted(String s) {
        return "\"" + s + "\"";
    }

    private String convertQueryResult(AttributeList queryResult) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append(this.quoted("records")).append(": [");
        AttributeList fieldAttrs = (AttributeList)((Attribute)queryResult.get(0)).getValue();
        String[] fieldHeaders = new String[fieldAttrs.size()];
        for (int i = 0; i < fieldHeaders.length; ++i) {
            Attribute attr = (Attribute)fieldAttrs.get(i);
            fieldHeaders[i] = (String)attr.getValue();
        }
        List srcRecords = this.asList(((Attribute)queryResult.get(1)).getValue());
        for (int recordIdx = 0; recordIdx < srcRecords.size(); ++recordIdx) {
            List record = (List)srcRecords.get(recordIdx);
            assert (record.size() == fieldHeaders.length);
            Serializable[] fieldValues = new Serializable[fieldHeaders.length];
            LogRecord rec = new LogRecord();
            int fieldIdx = 0;
            rec.setRecordNumber((Long)record.get(fieldIdx++));
            rec.setLoggedDateTime((Date)record.get(fieldIdx++));
            rec.setLoggedLevel((String)record.get(fieldIdx++));
            rec.setProductName((String)record.get(fieldIdx++));
            rec.setLoggerName((String)record.get(fieldIdx++));
            rec.setNameValuePairs((String)record.get(fieldIdx++));
            rec.setMessageID((String)record.get(fieldIdx++));
            rec.setMessage((String)record.get(fieldIdx++));
            sb.append(rec.toJSON());
            sb.append(",\n");
        }
        sb.append("]\n");
        sb.append("}\n");
        return sb.toString();
    }
}

