/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.OptionsResult;
import org.glassfish.admin.rest.provider.OptionsResultJsonProvider;
import org.glassfish.admin.rest.provider.OptionsResultXmlProvider;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.impl.StatisticImpl;
import org.jvnet.hk2.config.ConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProviderUtil {
    protected static final String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    protected static final String slashToDash(String string) {
        if (string != null && !string.isEmpty()) {
            return string.replaceAll("/", "-");
        }
        return string;
    }

    protected static final String readAsString(InputStream in) throws IOException {
        int l;
        InputStreamReader reader = new InputStreamReader(in);
        StringBuilder sb = new StringBuilder();
        char[] c = new char[1024];
        while ((l = reader.read(c)) != -1) {
            sb.append(c, 0, l);
        }
        return sb.toString();
    }

    protected static final String getElementLink(UriInfo uriInfo, String elementName) {
        try {
            elementName = URLEncoder.encode(elementName, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(ProviderUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        String link = uriInfo.getAbsolutePath().toString();
        return link.endsWith("/") ? link + elementName : link + "/" + elementName;
    }

    protected static String getStartXmlElement(String name) {
        assert (name != null && name.length() > 0);
        String result = "<";
        result = result + name;
        result = result + ">";
        return result;
    }

    protected static String getEndXmlElement(String name) {
        assert (name != null && name.length() > 0);
        String result = "<";
        result = result + "/";
        result = result + name;
        result = result + ">";
        return result;
    }

    protected static Map getStatistics(Statistic statistic) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method[] methods;
        HashMap<String, Object> results = new HashMap<String, Object>();
        Class<?> classObject = statistic.getClass();
        for (Method method : methods = classObject.getMethods()) {
            String name;
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier) || !(name = method.getName()).startsWith("get")) continue;
            name = name.substring("get".length());
            Class<?> returnType = method.getReturnType();
            if (!returnType.isPrimitive() && !returnType.getName().equals("java.lang.String")) continue;
            results.put(name, method.invoke((Object)statistic, null));
        }
        return results;
    }

    protected static Map<String, Object> getStatistic(Statistic statistic) {
        Map statsMap = Proxy.isProxyClass(statistic.getClass()) ? ((StatisticImpl)Proxy.getInvocationHandler(statistic)).getStaticAsMap() : ((StatisticImpl)statistic).getStaticAsMap();
        return statsMap;
    }

    protected static HashMap<String, String> getStringMap(Map map) {
        HashMap<String, String> stringMap = new HashMap<String, String>();
        if (map != null) {
            String key2 = null;
            Object value = null;
            for (String key2 : map.keySet()) {
                value = map.get(key2);
                stringMap.put(key2, value.toString());
            }
        }
        return stringMap;
    }

    protected static String getHtmlRespresentationForAttributes(ConfigBean proxy, UriInfo uriInfo) {
        StringBuilder result = new StringBuilder();
        Set attributes = proxy.model.getAttributeNames();
        System.out.println("attributes: " + attributes);
        MethodMetaData methodMetaData = ResourceUtil.getMethodMetaData(proxy);
        Set<String> parameters = methodMetaData.parameters();
        for (String parameter : parameters) {
            ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
            String xmlAttributeName = ResourceUtil.convertToXMLName(parameter);
            result.append(ProviderUtil.getHtmlRespresentationForParameter(parameter, parameterMetaData, proxy.attribute(xmlAttributeName)));
        }
        if (result.length() > 0) {
            return "<div><form action=\"" + uriInfo.getAbsolutePath().toString() + "\" method=\"post\"><dl>" + result.toString() + "<dt class=\"button\"></dt><dd class=\"button\"><input value=\"Update\" type=\"submit\"></dd>" + "</dl></form></div>";
        }
        return "";
    }

    protected static String getHtmlRespresentationsForCommand(MethodMetaData methodMetaData, String commandMethod, String commandDisplayName, UriInfo uriInfo) {
        String result = "";
        if (methodMetaData != null) {
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                if (methodMetaData.isFileUploadOperation() && parameter.equals("id")) {
                    parameterMetaData.setIsFileParameter(true);
                }
                result = result + ProviderUtil.getHtmlRespresentationForParameter(parameter, parameterMetaData);
            }
            if (result.equals("")) {
                result = " ";
            }
        }
        if (!result.equals("")) {
            String encType = methodMetaData.isFileUploadOperation() ? " enctype=\"multipart/form-data\"" : "";
            result = "<div><form action=\"" + uriInfo.getAbsolutePath().toString() + "\" method=\"" + "post\"" + encType + ">" + "<dl>" + result;
            if (commandMethod.equalsIgnoreCase("DELETE")) {
                result = result + "<input name=\"operation\" value=\"__deleteoperation\" type=\"hidden\">";
            }
            result = result + "<dt class=\"button\"></dt><dd class=\"button\"><input value=\"" + commandDisplayName + "\" type=\"submit\"></dd>";
            result = result + "</dl></form></div>";
        }
        return result;
    }

    protected static String getHtmlForComponent(String component, String heading, String result) {
        if (component != null && component.length() > 0) {
            result = result + "<h2>" + heading + "</h2>";
            result = result + component;
            result = result + "<hr class=\"separator\"/>";
        }
        return result;
    }

    protected static String getHint(UriInfo uriInfo, String mediaType) {
        String result = "";
        URI baseUri = uriInfo.getBaseUri();
        String monitoringLevelsConfigUrl = baseUri.getScheme() + "://" + baseUri.getHost() + ":" + baseUri.getPort() + "/management/domain/configs/config/server-config/monitoring-service/module-monitoring-levels";
        String name = Util.localStrings.getLocalString("rest.monitoring.levels.hint.heading", "Hint");
        String value = Util.localStrings.getLocalString("rest.monitoring.levels.hint.message", "Module monitoring levels may be OFF. To set module monitoring levels please visit following url: {0}", new Object[]{monitoringLevelsConfigUrl});
        if (mediaType.equals("text/html")) {
            monitoringLevelsConfigUrl = "<br><a href=\"" + monitoringLevelsConfigUrl + "\">" + monitoringLevelsConfigUrl + "</a>";
            value = Util.localStrings.getLocalString("rest.monitoring.levels.hint.message", "Module monitoring levels may be OFF. To set module monitoring levels please visit following url: {0}", new Object[]{monitoringLevelsConfigUrl});
            result = result + "<h2>" + name + "</h2>";
            result = result + value + "<br>";
            result = "<div>" + result + "</div>" + "<br>";
            return result;
        }
        if (mediaType.equals("application/json")) {
            result = " " + ProviderUtil.quote(name) + ":" + ProviderUtil.jsonValue(value);
            return result;
        }
        if (mediaType.equals("application/xml")) {
            result = result + " " + name + "=" + ProviderUtil.quote(value);
            return result;
        }
        return result;
    }

    protected String getTypeKey(String uri) {
        return "entity";
    }

    protected static String jsonValue(Object value) {
        String result = "";
        result = value.getClass().getName().equals("java.lang.String") ? ProviderUtil.quote(value.toString()) : value.toString();
        return result;
    }

    public static String getHtmlHeader() {
        String result = "<html><head>";
        result = result + "<title>GlassFish REST Interface</title>";
        result = result + ProviderUtil.getInternalStyleSheet();
        result = result + "</head><body>";
        result = result + "<h1 class=\"mainheader\">GlassFish REST Interface</h1>";
        result = result + "<hr>";
        return result;
    }

    protected static String getJsonForMethodMetaData(OptionsResult metaData, String indent) {
        OptionsResultJsonProvider provider = new OptionsResultJsonProvider();
        return provider.getRespresenationForMethodMetaData(metaData, indent);
    }

    protected static String getXmlForMethodMetaData(OptionsResult metaData, String indent) {
        OptionsResultXmlProvider provider = new OptionsResultXmlProvider();
        return provider.getRespresenationForMethodMetaData(metaData, indent);
    }

    protected static String getResourcesKey() {
        return "childResources";
    }

    protected static String getResourceKey() {
        return "childResource";
    }

    protected static String getMethodsKey() {
        return "methods";
    }

    private static String getHtmlRespresentationForParameter(String parameter, ParameterMetaData parameterMetaData) {
        return ProviderUtil.getHtmlRespresentationForParameter(parameter, parameterMetaData, null);
    }

    private static String getHtmlRespresentationForParameter(String parameter, ParameterMetaData parameterMetaData, String parameterValue) {
        boolean keyAttribute;
        String defaultValue;
        String parameterType;
        String result = parameter;
        String string = parameterType = parameterMetaData.isFileParameter() ? "file" : "text";
        if (parameterMetaData.getAttributeValue("optional").equalsIgnoreCase("false")) {
            result = result + "<sup>*</sup>";
        }
        result = "<dt><label for=\"" + parameter + "\">" + result + ":&nbsp;" + "</label></dt>";
        boolean isBoolean = false;
        if (parameterMetaData.getAttributeValue("type").endsWith("java.lang.Boolean") || parameterMetaData.getAttributeValue("type").equals("boolean")) {
            isBoolean = true;
        }
        boolean hasAcceptableValues = false;
        String acceptableValues = parameterMetaData.getAttributeValue("acceptableValues");
        if (acceptableValues != null && acceptableValues.length() > 0) {
            hasAcceptableValues = true;
        }
        boolean hasValue = false;
        if ((parameterValue == null || parameterValue.equals("")) && (defaultValue = parameterMetaData.getAttributeValue("defaultValue")) != null && defaultValue.length() > 0) {
            parameterValue = defaultValue;
        }
        if (parameterValue != null && parameterValue.length() > 0) {
            hasValue = true;
        }
        if (keyAttribute = Boolean.valueOf(parameterMetaData.getAttributeValue("key")).booleanValue()) {
            if (hasValue) {
                result = result + "<dd><input name=\"" + parameter + "\" value =\"" + parameterValue + "\" type=\"" + parameterType + "\" disabled=\"disabled\"></dd>";
            }
        } else if (isBoolean || hasAcceptableValues) {
            result = result + "<dd><select name=" + parameter + ">";
            String[] values = isBoolean ? new String[]{"true", "false"} : ProviderUtil.stringToArray(acceptableValues, ",");
            for (String value : values) {
                if (hasValue && value.equalsIgnoreCase(parameterValue)) {
                    if (isBoolean) {
                        parameterValue = parameterValue.toLowerCase();
                    }
                    result = result + "<option selected>" + parameterValue + "<br>";
                    continue;
                }
                result = result + "<option>" + value + "<br>";
            }
            result = result + "</select></dd>";
        } else {
            result = hasValue ? result + "<dd><input name=\"" + parameter + "\" value =\"" + parameterValue + "\" type=\"" + parameterType + "\"></dd>" : result + "<dd><input name=\"" + parameter + "\" type=\"" + parameterType + "\"></dd>";
        }
        return result;
    }

    private static String[] stringToArray(String str, String delimiter) {
        String[] retString = new String[]{};
        if (str != null) {
            if (delimiter == null) {
                delimiter = " ";
            }
            StringTokenizer tokens = new StringTokenizer(str, delimiter);
            retString = new String[tokens.countTokens()];
            int i = 0;
            while (tokens.hasMoreTokens()) {
                retString[i++] = tokens.nextToken();
            }
        }
        return retString;
    }

    private static String getInternalStyleSheet() {
        String result = "<style type=\"text/css\">";
        result = result + "body {";
        result = result + "font-size:75%;font-family:verdana,arial,'sans serif';";
        result = result + "background-repeat:repeat-x;background-color:#F0F0F0;";
        result = result + "color:#303030;";
        result = result + "margin:60px;margin-top:20px;margin-bottom:20px;margin-right:60px;margin-left:60px;";
        result = result + "}";
        result = result + "h1 {font-size:200%;background-color:#E0E0E0}";
        result = result + "h2 {font-size:140%;background-color:#E8E8E8}";
        result = result + "h3 {font-size:110%;background-color:#E8E8E8}";
        result = result + "h1.mainheader {color:#101010;font-size:200%;background-color:#D8D8D8;text-align:center}";
        result = result + "a:link {color:#000080;}";
        result = result + "a:hover {color:red;}";
        result = result + "input[type=\"text\"] {background-color:#F8F8F8;border-style:inset;width:350px}";
        result = result + "dl {position: relative;width:500px}";
        result = result + "dt {clear: both;float:left;width: 210px;padding: 4px 0 2px 0;text-align:left}";
        result = result + "dd {float: left;width: 200px;margin: 0 0 8px 0;padding-left: 6px;}";
        result = result + ".separator{clear:both}";
        result = result + "</style>";
        return result;
    }
}

