/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.provider.StringListResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml"})
public class StringListResultXmlProvider
extends ProviderUtil
implements MessageBodyWriter<StringListResult> {
    @Context
    protected UriInfo uriInfo;

    public long getSize(StringListResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        try {
            if (Class.forName("org.glassfish.admin.rest.provider.StringListResult").equals(genericType)) {
                return mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE);
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public void writeTo(StringListResult proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getXml(proxy).getBytes());
    }

    private String getXml(StringListResult proxy) {
        String uri = this.uriInfo.getAbsolutePath().toString();
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String indent = "  ";
        String result = "<";
        result = result + this.getTypeKey(name);
        if (proxy.isError()) {
            String attribute = this.getAttribute("error", proxy.getErrorMessage());
            if (attribute != null && attribute.length() > 1) {
                result = result + " ";
                result = result + attribute;
            }
            result = result + ">";
        } else {
            result = result + ">";
            for (String message : proxy.getMessages()) {
                result = result + "\n" + indent;
                result = result + StringListResultXmlProvider.getStartXmlElement(proxy.getName());
                result = result + message;
                result = result + StringListResultXmlProvider.getEndXmlElement(proxy.getName());
            }
        }
        result = result + "\n\n" + indent;
        result = result + "<" + StringListResultXmlProvider.getMethodsKey() + ">";
        result = result + StringListResultXmlProvider.getXmlForMethodMetaData(proxy.getMetaData(), indent + "  ");
        result = result + "\n" + indent + "</" + StringListResultXmlProvider.getMethodsKey() + ">";
        result = result + "\n\n" + "</" + this.getTypeKey(name) + ">";
        return result;
    }

    private String getAttribute(String name, String value) {
        String result = "";
        result = result + name + "=" + StringListResultXmlProvider.quote(value);
        return result;
    }
}

