/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManager {
    private static SessionManager theSessionManager = new SessionManager();
    private final SecureRandom randomGenerator = new SecureRandom();
    private Map<Long, SessionData> activeSessions = new ConcurrentHashMap<Long, SessionData>();

    private SessionManager() {
    }

    public static SessionManager getSessionManager() {
        return theSessionManager;
    }

    public String createSession() {
        long sessionId;
        while (this.isSessionExist(sessionId = this.randomGenerator.nextLong())) {
        }
        this.saveSession(sessionId);
        return Long.toString(sessionId);
    }

    public boolean authenticate(String sessionId) {
        SessionData sessionData;
        boolean authenticated = false;
        Long sessionIdKey = this.convertToSessionIdKey(sessionId);
        if (sessionIdKey != null && (sessionData = this.activeSessions.get(sessionIdKey)) != null) {
            authenticated = sessionData.isSessionActive();
            if (authenticated) {
                sessionData.updateLastAccessTime();
            } else {
                this.activeSessions.remove(sessionIdKey);
            }
        }
        return authenticated;
    }

    public boolean deleteSession(String sessionId) {
        boolean sessionDeleted = false;
        Long sessionIdKey = this.convertToSessionIdKey(sessionId);
        if (sessionId != null) {
            SessionData removedSession = this.activeSessions.remove(sessionIdKey);
            sessionDeleted = removedSession != null;
        }
        return sessionDeleted;
    }

    private Long convertToSessionIdKey(String sessionId) {
        Long sessionIdKey;
        try {
            sessionIdKey = Long.parseLong(sessionId);
        }
        catch (NumberFormatException e) {
            sessionIdKey = null;
        }
        return sessionIdKey;
    }

    private void saveSession(long sessionId) {
        this.purgeInactiveSessions();
        this.activeSessions.put(sessionId, new SessionData(sessionId));
    }

    private void purgeInactiveSessions() {
        Set<Map.Entry<Long, SessionData>> activeSessionsSet = this.activeSessions.entrySet();
        for (Map.Entry<Long, SessionData> entry : activeSessionsSet) {
            if (entry.getValue().isSessionActive()) continue;
            activeSessionsSet.remove(entry);
        }
    }

    private boolean isSessionExist(long sessionId) {
        return this.activeSessions.containsKey(sessionId);
    }

    private static class SessionData {
        private static long INACTIVE_SESSION_DEFAULT_LIFETIME_IN_MILIS = 1800000L;
        private long sessionId;
        private long creationTime;
        private long lassAccessedTime;
        private long inactiveSessionLifeTime;

        public SessionData(long sessionId) {
            this.lassAccessedTime = this.creationTime = System.currentTimeMillis();
            this.inactiveSessionLifeTime = INACTIVE_SESSION_DEFAULT_LIFETIME_IN_MILIS;
            this.sessionId = sessionId;
        }

        public boolean isSessionActive() {
            return this.lassAccessedTime + this.inactiveSessionLifeTime > System.currentTimeMillis();
        }

        public void updateLastAccessTime() {
            this.lassAccessedTime = System.currentTimeMillis();
        }
    }
}

