/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.logviewer;

import java.io.StringWriter;
import java.util.Date;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class LogRecord {
    long recordNumber;
    Date loggedDateTime;
    String loggedLevel;
    String productName;
    String loggerName;
    String nameValuePairs;
    String messageID;
    String Message;

    LogRecord() {
    }

    public String getMessage() {
        return this.Message;
    }

    public void setMessage(String Message) {
        this.Message = Message;
    }

    public Date getLoggedDateTime() {
        return this.loggedDateTime;
    }

    public void setLoggedDateTime(Date loggedDateTime) {
        this.loggedDateTime = loggedDateTime;
    }

    public String getLoggedLevel() {
        return this.loggedLevel;
    }

    public void setLoggedLevel(String loggedLevel) {
        this.loggedLevel = loggedLevel;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getNameValuePairs() {
        return this.nameValuePairs;
    }

    public void setNameValuePairs(String nameValuePairs) {
        this.nameValuePairs = nameValuePairs;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public void setRecordNumber(long recordNumber) {
        this.recordNumber = recordNumber;
    }

    private String quoted(String s) {
        return "\"" + s + "\"";
    }

    public String toJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        sb.append(this.quoted("recordNumber")).append(':').append(this.recordNumber).append(",\n");
        sb.append(this.quoted("loggedDateTimeInMS")).append(':').append(this.loggedDateTime.getTime()).append(",\n");
        sb.append(this.quoted("loggedLevel")).append(':').append(this.quoted(this.loggedLevel)).append(",\n");
        sb.append(this.quoted("productName")).append(':').append(this.quoted(this.productName)).append(",\n");
        sb.append(this.quoted("loggerName")).append(':').append(this.quoted(this.loggerName)).append(",\n");
        sb.append(this.quoted("nameValuePairs")).append(':').append(this.quoted(this.nameValuePairs)).append(",\n");
        sb.append(this.quoted("messageID")).append(':').append(this.quoted(this.messageID)).append(",\n");
        sb.append(this.quoted("Message")).append(':').append(this.quoted(this.Message.replaceAll("\n", Matcher.quoteReplacement("\\\n")))).append("}\n");
        return sb.toString();
    }

    public String toXML() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.newDocument();
            Element result = d.createElement("record");
            result.setAttribute("recordNumber", "" + this.recordNumber);
            result.setAttribute("loggedDateTimeInMS", "" + this.loggedDateTime.getTime());
            result.setAttribute("loggedLevel", this.loggedLevel);
            result.setAttribute("productName", this.productName);
            result.setAttribute("loggerName", this.loggerName);
            result.setAttribute("nameValuePairs", this.nameValuePairs);
            result.setAttribute("messageID", this.messageID);
            result.setNodeValue(this.Message);
            d.appendChild(result);
            return this.xmlToString(d);
        }
        catch (ParserConfigurationException pex) {
            throw new RuntimeException(pex);
        }
    }

    private String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return null;
    }
}

