/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.StringListResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class StringListResultJsonProvider
extends BaseProvider<StringListResult> {
    public StringListResultJsonProvider() {
        super(StringListResult.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected String getContent(StringListResult proxy) {
        String indent = "  ";
        String uri = this.uriInfo.getAbsolutePath().toString();
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String result = "{";
        result = result + "\n\n" + indent;
        result = result + ProviderUtil.getTypeKey(name);
        if (proxy.isError()) {
            result = result + ":{";
            result = result + this.getAttribute("error", proxy.getErrorMessage());
            result = result + "},";
        } else {
            result = result + ":[";
            boolean firstEntry = true;
            for (String message : proxy.getMessages()) {
                if (!firstEntry) {
                    result = result + ",";
                }
                result = result + "\n" + indent + "  ";
                result = result + ProviderUtil.quote(message);
                firstEntry = false;
            }
            result = result + "],";
        }
        result = result + "\n\n" + indent;
        result = result + ProviderUtil.quote(ProviderUtil.getMethodsKey()) + ":{";
        result = result + ProviderUtil.getJsonForMethodMetaData(proxy.getMetaData(), indent + "  ");
        result = result + "\n" + indent + "}";
        result = result + "\n\n" + "}";
        return result;
    }

    private String getAttribute(String name, String value) {
        String result = "";
        result = result + ProviderUtil.quote(name) + " : " + ProviderUtil.quote(value);
        return result;
    }
}

