/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResult;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class GetResultJsonProvider
extends BaseProvider<GetResult> {
    public GetResultJsonProvider() {
        super(GetResult.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected String getContent(GetResult proxy) {
        String indent = "  ";
        String result = "{";
        result = result + "\n\n" + indent;
        result = result + ProviderUtil.quote(ProviderUtil.getTypeKey(Util.getName(this.uriInfo.getAbsolutePath().toString(), '/'))) + ":{";
        result = result + this.getAttributes(proxy.getDom());
        result = result + "},";
        result = result + "\n\n" + indent;
        result = result + ProviderUtil.quote(ProviderUtil.getMethodsKey()) + ":{";
        result = result + ProviderUtil.getJsonForMethodMetaData(proxy.getMetaData(), indent + "  ");
        result = result + "\n" + indent + "}";
        if (proxy.getDom().getElementNames().size() > 0 || proxy.getCommandResourcesPaths().length > 0 || "applications".equals(Util.getName(this.uriInfo.getPath(), '/'))) {
            result = result + ",";
            result = result + "\n\n" + indent;
            result = result + ProviderUtil.quote(ProviderUtil.getResourcesKey()) + ":[";
            result = result + this.getResourcesLinks(proxy.getDom(), proxy.getCommandResourcesPaths(), indent + "  ");
            result = result + "\n" + indent + "]";
        }
        result = result + "\n\n" + "}";
        return result;
    }

    private String getAttributes(Dom proxy) {
        StringBuilder result = new StringBuilder();
        Set attributeNames = proxy.model.getAttributeNames();
        for (String attributeName : attributeNames) {
            result.append(ProviderUtil.quote(Util.eleminateHypen(attributeName))).append(":").append(ProviderUtil.quote(proxy.attribute(attributeName))).append(", ");
        }
        return result.toString().trim();
    }

    private String getResourcesLinks(Dom proxy, String[][] commandResourcesPaths, String indent) {
        String result = "";
        Set elementNames = proxy.getElementNames();
        if (elementNames.isEmpty() && "applications".equals(Util.getName(this.uriInfo.getPath(), '/'))) {
            elementNames.add("application");
        }
        for (String elementName : elementNames) {
            try {
                result = result + "\n" + indent;
                result = result + ProviderUtil.quote(ProviderUtil.getElementLink(this.uriInfo, elementName));
                result = result + ",";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int endIndex = result.length() - 1;
        if (endIndex > 0) {
            result = result.substring(0, endIndex);
        }
        for (String[] commandResourcePath : commandResourcesPaths) {
            try {
                if (result.length() > 0) {
                    result = result + ",";
                }
                result = result + "\n" + indent;
                result = result + ProviderUtil.quote(ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

