/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.OptionsResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class OptionsResultJsonProvider
extends BaseProvider<OptionsResult> {
    private static final String METHOD = "method";
    private static final String NAME = "name";
    private static final String MESSAGE_PARAMETERS = "messageParameters";

    public OptionsResultJsonProvider() {
        super(OptionsResult.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected String getContent(OptionsResult proxy) {
        String indent = "  ";
        String result = "{" + ProviderUtil.quote(proxy.getName()) + ":";
        result = result + "\n" + indent + "{";
        result = result + this.getRespresenationForMethodMetaData(proxy, indent + "  ");
        result = result + "\n" + indent + "}";
        result = result + "\n}";
        return result;
    }

    String getRespresenationForMethodMetaData(OptionsResult proxy, String indent) {
        String result = "";
        Set<String> methods = proxy.methods();
        Iterator<String> iterator = methods.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            String method = iterator.next();
            if (!first) {
                result = result + ",";
            }
            MethodMetaData methodMetaData = proxy.getMethodMetaData(method);
            result = result + this.getMethod(method, methodMetaData, indent);
            first = false;
        }
        return result;
    }

    private String getMethod(String method, MethodMetaData methodMetaData, String indent) {
        String result = "\n" + indent;
        result = result + ProviderUtil.quote(METHOD) + ":{";
        result = result + "\n" + indent + "  " + ProviderUtil.quote(NAME) + ":" + ProviderUtil.quote(method);
        result = result + this.getQueryParams(methodMetaData, indent + "  ");
        result = result + this.getMessageParams(methodMetaData, indent + "  ");
        result = result + "\n" + indent + "}";
        return result;
    }

    private String getQueryParams(MethodMetaData methodMetaData, String indent) {
        String result = "";
        if (methodMetaData.sizeQueryParamMetaData() > 0) {
            result = result + "," + "\n" + indent;
            result = result + ProviderUtil.quote("Query Parameters") + ":{";
            Set<String> queryParams = methodMetaData.queryParams();
            Iterator<String> iterator = queryParams.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    result = result + ",";
                }
                String queryParam = iterator.next();
                ParameterMetaData parameterMetaData = methodMetaData.getQureyParamMetaData(queryParam);
                result = result + this.getParameter(queryParam, parameterMetaData, indent + "  ");
                first = false;
            }
            result = result + "\n" + indent + "}";
        }
        return result;
    }

    private String getMessageParams(MethodMetaData methodMetaData, String indent) {
        String result = "";
        if (methodMetaData.sizeParameterMetaData() > 0) {
            result = result + "," + "\n" + indent;
            result = result + ProviderUtil.quote(MESSAGE_PARAMETERS) + ":{";
            Set<String> parameters = methodMetaData.parameters();
            Iterator<String> iterator = parameters.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    result = result + ",";
                }
                String parameter = iterator.next();
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result = result + this.getParameter(parameter, parameterMetaData, indent + "  ");
                first = false;
            }
            result = result + "\n" + indent + "}";
        }
        return result;
    }

    private String getParameter(String parameter, ParameterMetaData parameterMetaData, String indent) {
        String result = "\n" + indent;
        result = result + ProviderUtil.quote(parameter) + ":{";
        Set<String> attributes = parameterMetaData.attributes();
        Iterator<String> iterator = attributes.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                result = result + ", ";
            }
            String attributeName = iterator.next();
            String attributeValue = parameterMetaData.getAttributeValue(attributeName);
            result = result + this.getAttribute(attributeName, attributeValue);
            first = false;
        }
        result = result + "}";
        return result;
    }

    private String getAttribute(String name, String value) {
        String result = "";
        result = result + ProviderUtil.quote(name) + ":" + ProviderUtil.quote(value);
        return result;
    }
}

