/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.StringListResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml"})
public class StringListResultXmlProvider
extends BaseProvider<StringListResult> {
    public StringListResultXmlProvider() {
        super(StringListResult.class, MediaType.APPLICATION_XML_TYPE);
    }

    @Override
    protected String getContent(StringListResult proxy) {
        String uri = this.uriInfo.getAbsolutePath().toString();
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String indent = "  ";
        String result = "<";
        result = result + ProviderUtil.getTypeKey(name);
        if (proxy.isError()) {
            String attribute = this.getAttribute("error", proxy.getErrorMessage());
            if (attribute != null && attribute.length() > 1) {
                result = result + " ";
                result = result + attribute;
            }
            result = result + ">";
        } else {
            result = result + ">";
            for (String message : proxy.getMessages()) {
                result = result + "\n" + indent;
                result = result + ProviderUtil.getStartXmlElement(proxy.getName());
                result = result + message;
                result = result + ProviderUtil.getEndXmlElement(proxy.getName());
            }
        }
        result = result + "\n\n" + indent;
        result = result + "<" + ProviderUtil.getMethodsKey() + ">";
        result = result + ProviderUtil.getXmlForMethodMetaData(proxy.getMetaData(), indent + "  ");
        result = result + "\n" + indent + "</" + ProviderUtil.getMethodsKey() + ">";
        result = result + "\n\n" + "</" + ProviderUtil.getTypeKey(name) + ">";
        return result;
    }

    private String getAttribute(String name, String value) {
        String result = "";
        result = result + name + "=" + ProviderUtil.quote(value);
        return result;
    }
}

