/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jersey.api.core.ResourceContext;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.results.StringListResult;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionLeafResource {
    @Context
    protected HttpHeaders requestHeaders;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ResourceContext resourceContext;
    protected List<String> entity;
    protected Dom parent;
    protected String tagName;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CollectionLeafResource.class);

    public void setEntity(List<String> p) {
        this.entity = p;
    }

    public List<String> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.leafElements(tagName);
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
    public StringListResult get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.getEntity() == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return new StringListResult(this.getName(), this.getEntity(), this.getPostCommand(), this.getDeleteCommand(), this.options());
    }

    @POST
    @Produces(value={"text/html;qs=2"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response create(HashMap<String, String> data) {
        if (data.containsKey("operation") && data.get("operation").equals("__deleteoperation")) {
            data.remove("operation");
            return this.delete(data);
        }
        return this.runCommand(this.getPostCommand(), data, "rest.resource.create.message", "\"{0}\" created successfully.", "rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.");
    }

    @DELETE
    @Produces(value={"text/html;qs=2"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response delete(HashMap<String, String> data) {
        return this.runCommand(this.getDeleteCommand(), data, "rest.resource.delete.message", "\"{0}\" deleted successfully.", "rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.");
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public OptionsResult options() {
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        try {
            String deleteCommand;
            optionsResult.putMethodMetaData("GET", new MethodMetaData());
            String postCommand = this.getPostCommand();
            if (postCommand != null) {
                MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(postCommand, RestService.getHabitat(), RestService.logger);
                postMethodMetaData.setDescription("Create");
                optionsResult.putMethodMetaData("POST", postMethodMetaData);
            }
            if ((deleteCommand = this.getDeleteCommand()) != null) {
                MethodMetaData deleteMethodMetaData = ResourceUtil.getMethodMetaData(deleteCommand, RestService.getHabitat(), RestService.logger);
                deleteMethodMetaData.setDescription("Delete");
                optionsResult.putMethodMetaData("DELETE", deleteMethodMetaData);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return optionsResult;
    }

    private void addDefaultParameter(HashMap<String, String> data) {
        int index = this.uriInfo.getAbsolutePath().getPath().lastIndexOf(47);
        String defaultParameterValue = this.uriInfo.getAbsolutePath().getPath().substring(index + 1);
        data.put("DEFAULT", defaultParameterValue);
    }

    protected String getPostCommand() {
        return null;
    }

    protected String getDeleteCommand() {
        return null;
    }

    protected String getName() {
        return Util.getResourceName(this.uriInfo);
    }

    private Response runCommand(String commandName, HashMap<String, String> data, String successMsgKey, String successMsg, String operationForbiddenMsgKey, String operationForbiddenMsg) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            ResourceUtil.purgeEmptyEntries(data);
            ResourceUtil.adjustParameters(data);
            String attributeName = data.get("DEFAULT");
            if (null != commandName) {
                String typeOfResult = ResourceUtil.getResultType(this.requestHeaders);
                ActionReport actionReport = ResourceUtil.runCommand(commandName, data, RestService.getHabitat(), typeOfResult);
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode == ActionReport.ExitCode.SUCCESS) {
                    String successMessage = localStrings.getLocalString(successMsgKey, successMsg, new Object[]{attributeName});
                    return ResourceUtil.getResponse(200, successMessage, this.requestHeaders, this.uriInfo);
                }
                String errorMessage = this.getErrorMessage(data, actionReport);
                return ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo);
            }
            String message = localStrings.getLocalString(operationForbiddenMsgKey, operationForbiddenMsg, new Object[]{this.uriInfo.getAbsolutePath()});
            return ResourceUtil.getResponse(403, message, this.requestHeaders, this.uriInfo);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getErrorMessage(HashMap<String, String> data, ActionReport ar) {
        String message = ar.getMessage();
        return message;
    }
}

