/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResult;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml"})
public class GetResultXmlProvider
extends BaseProvider<GetResult> {
    public GetResultXmlProvider() {
        super(GetResult.class, MediaType.APPLICATION_XML_TYPE);
    }

    @Override
    protected String getContent(GetResult proxy) {
        String indent = "  ";
        String typeKey = ProviderUtil.getTypeKey(Util.getName(this.uriInfo.getAbsolutePath().toString(), '/'));
        String result = "<";
        result = result + typeKey;
        String attributes = this.getAttributes(proxy.getDom());
        if (attributes != null && attributes.length() > 1) {
            result = result + " ";
            result = result + this.getAttributes(proxy.getDom());
        }
        result = result + ">";
        result = result + "\n\n" + indent;
        result = result + ProviderUtil.getStartXmlElement(ProviderUtil.getMethodsKey());
        result = result + ProviderUtil.getXmlForMethodMetaData(proxy.getMetaData(), indent + "  ");
        result = result + "\n" + indent + ProviderUtil.getEndXmlElement(ProviderUtil.getMethodsKey());
        if (proxy.getDom().getElementNames().size() > 0 || proxy.getCommandResourcesPaths().length > 0 || "applications".equals(Util.getName(this.uriInfo.getPath(), '/'))) {
            result = result + "\n\n" + indent;
            result = result + ProviderUtil.getStartXmlElement(ProviderUtil.getResourcesKey().replace(' ', '-'));
            result = result + this.getResourcesLinks(proxy.getDom(), proxy.getCommandResourcesPaths(), indent + "  ");
            result = result + "\n" + indent;
            result = result + ProviderUtil.getEndXmlElement(ProviderUtil.getResourcesKey().replace(' ', '-'));
        }
        result = result + "\n\n" + ProviderUtil.getEndXmlElement(typeKey);
        return result;
    }

    private String getAttributes(Dom proxy) {
        StringBuilder result = new StringBuilder();
        Set attributeNames = proxy.model.getAttributeNames();
        for (String attributeName : attributeNames) {
            result.append(Util.eleminateHypen(attributeName)).append("=").append(ProviderUtil.quote(proxy.attribute(attributeName))).append(" ");
        }
        return result.toString().trim();
    }

    private String getResourcesLinks(Dom proxy, String[][] commandResourcesPaths, String indent) {
        String result = "";
        Set elementNames = proxy.getElementNames();
        if (elementNames.isEmpty() && "applications".equals(Util.getName(this.uriInfo.getPath(), '/'))) {
            elementNames.add("application");
        }
        for (String elementName : elementNames) {
            try {
                result = result + "\n" + indent;
                result = result + ProviderUtil.getStartXmlElement(ProviderUtil.getResourceKey().replace(' ', '-'));
                result = result + ProviderUtil.getElementLink(this.uriInfo, elementName);
                result = result + ProviderUtil.getEndXmlElement(ProviderUtil.getResourceKey().replace(' ', '-'));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String[] commandResourcePath : commandResourcesPaths) {
            try {
                result = result + "\n" + indent;
                result = result + ProviderUtil.getStartXmlElement(ProviderUtil.getResourceKey().replace(' ', '-'));
                result = result + ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0]);
                result = result + ProviderUtil.getEndXmlElement(ProviderUtil.getResourceKey().replace(' ', '-'));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

