/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.clientutils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallingUtils {
    public static String getJsonForProperties(final Map<String, String> properties) {
        return MarshallingUtils.getJsonForProperties((List<Map<String, String>>)new ArrayList<Map<String, String>>(){
            {
                this.add(properties);
            }
        });
    }

    public static String getJsonForProperties(List<Map<String, String>> properties) {
        JSONArray ja = new JSONArray();
        for (Map<String, String> property : properties) {
            ja.put((Object)MarshallingUtils.getJsonObjectForMap(property));
        }
        return ja.toString();
    }

    public static List<Map<String, String>> getPropertiesFromJson(String json) {
        ArrayList<Map<String, String>> properties;
        if ((json = json.trim()).startsWith("{")) {
            properties = new ArrayList<Map<String, String>>();
            properties.add(MarshallingUtils.processJsonMap(json));
        } else if (json.startsWith("[")) {
            properties = MarshallingUtils.processJsonList(json);
        } else {
            throw new RuntimeException("The JSON string must start with { or [");
        }
        return properties;
    }

    public static String getXmlForProperties(final Map<String, String> properties) {
        return MarshallingUtils.getXmlForProperties((List<Map<String, String>>)new ArrayList<Map<String, String>>(){
            {
                this.add(properties);
            }
        });
    }

    public static String getXmlForProperties(List<Map<String, String>> properties) {
        try {
            Object xml = null;
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            StringWriter sw = new StringWriter();
            XMLStreamWriter writer = outputFactory.createXMLStreamWriter(sw);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("list");
            for (Map<String, String> property : properties) {
                writer.writeStartElement("map");
                for (Map.Entry<String, String> entry : property.entrySet()) {
                    writer.writeStartElement("entry");
                    writer.writeAttribute("key", entry.getKey());
                    writer.writeAttribute("value", entry.getValue());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
            writer.close();
            return sw.toString();
        }
        catch (Exception ex) {
            Logger.getLogger(MarshallingUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public static List<Map<String, String>> getPropertiesFromXml(String xml) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        InputStream input = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isValidating", false);
            input = new ByteArrayInputStream(xml.trim().getBytes("UTF-8"));
            XMLStreamReader parser = inputFactory.createXMLStreamReader(input);
            while (parser.hasNext()) {
                int event = parser.next();
                switch (event) {
                    case 1: {
                        if (!"list".equals(parser.getLocalName())) break;
                        list = MarshallingUtils.processXmlList(parser);
                    }
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MarshallingUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MarshallingUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return list;
    }

    public static JSONObject getJsonObjectForMap(Map<String, String> property) throws RuntimeException {
        JSONObject jo = new JSONObject();
        for (Map.Entry<String, String> elem : property.entrySet()) {
            try {
                jo.put(elem.getKey(), (Object)elem.getValue());
            }
            catch (JSONException ex) {
                Logger.getLogger(MarshallingUtils.class.getName()).log(Level.SEVERE, null, ex);
                throw new RuntimeException(ex);
            }
        }
        return jo;
    }

    protected static Map<String, String> processJsonMap(String json) {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }

    protected static List<Map<String, String>> processJsonList(String json) {
        ArrayList<Map<String, String>> properties = new ArrayList<Map<String, String>>();
        try {
            JSONArray ja = new JSONArray(json);
            for (int i = 0; i < ja.length(); ++i) {
                JSONObject jo = ja.getJSONObject(i);
                HashMap<String, String> property = new HashMap<String, String>();
                Iterator iter = jo.keys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    property.put(key, (String)jo.get(key));
                }
                properties.add(property);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MarshallingUtils.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
        return properties;
    }

    protected static List processXmlList(XMLStreamReader parser) throws XMLStreamException {
        ArrayList<Map> list = new ArrayList<Map>();
        boolean endOfList = false;
        block4: while (!endOfList) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    if (!"map".equals(parser.getLocalName())) continue block4;
                    list.add(MarshallingUtils.processXmlMap(parser));
                    continue block4;
                }
                case 2: {
                    if (!"list".equals(parser.getLocalName())) continue block4;
                    endOfList = true;
                    continue block4;
                }
            }
            throw new RuntimeException("XML parsing error");
        }
        return list;
    }

    protected static Object processXmlListEntry(XMLStreamReader parser) throws XMLStreamException {
        Object entry = null;
        boolean endOfEntry = false;
        while (!endOfEntry) {
            int event = parser.next();
            switch (event) {
                case 10: {
                    if (!"value".equals(parser.getLocalName())) break;
                    entry = parser.getText();
                    break;
                }
                case 1: {
                    if (!"map".equals(parser.getLocalName())) break;
                    entry = MarshallingUtils.processXmlMap(parser);
                    break;
                }
                case 2: {
                    if (!"entry".equals(parser.getLocalName())) break;
                    endOfEntry = true;
                }
            }
        }
        return entry;
    }

    protected static Map processXmlMap(XMLStreamReader parser) throws XMLStreamException {
        boolean endOfMap = false;
        HashMap<String, String> entry = new HashMap<String, String>();
        block4: while (!endOfMap) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    if ("entry".equals(parser.getLocalName())) {
                        String name = parser.getAttributeValue(null, "key");
                        String value = parser.getAttributeValue(null, "value");
                        entry.put(name, value);
                        continue block4;
                    }
                    if ("map".equals(parser.getLocalName())) {
                        throw new RuntimeException("Unexpected XML element found:  " + parser.getLocalName());
                    }
                    if (!"list".equals(parser.getLocalName())) continue block4;
                    throw new RuntimeException("Unexpected XML element found:  " + parser.getLocalName());
                }
                case 2: {
                    if (!"map".equals(parser.getLocalName())) continue block4;
                    endOfMap = true;
                    continue block4;
                }
            }
            throw new RuntimeException("XML parsing error");
        }
        return entry;
    }

    public static void main(String ... args) {
        String json = "[{\"name\":\"foo1\",\"value\":\"bar1\",\"description\":\"baz1\"},{\"name\":\"foo2\",\"value\":\"bar2\",\"description\":\"baz2\"},{\"name\":\"foo3\",\"value\":\"bar3\",\"description\":\"baz3\"}]";
        String xml = "<list><map><entry key=\"name\" value=\"foo1\"/><entry key=\"value\" value=\"bar1\"/><entry key=\"description\" value=\"baz1\"/></map><map><entry key=\"name\" value=\"foo2\"/><entry key=\"value\" value=\"bar2\"/><entry key=\"description\" value=\"baz2\"/></map><map><entry key=\"name\" value=\"foo3\"/><entry key=\"value\" value=\"bar3\"/><entry key=\"description\" value=\"baz3\"/></map></list>";
        List<Map<String, String>> properties = MarshallingUtils.getPropertiesFromJson(json);
        System.out.println("************");
        System.out.println("getPropertiesFromJson = " + properties);
        String newJson = MarshallingUtils.getJsonForProperties(properties);
        System.out.println("************");
        System.out.println("newJson = " + newJson);
        properties = MarshallingUtils.getPropertiesFromXml(xml);
        System.out.println("************");
        System.out.println("getPropertiesFromXml = " + properties);
        String newXml = MarshallingUtils.getXmlForProperties(properties);
        System.out.println("************");
        System.out.println("xml = " + xml);
        System.out.println("newXml = " + newXml);
        properties = MarshallingUtils.getPropertiesFromXml(newXml);
        System.out.println(properties);
    }
}

