/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResultList;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class GetResultListHtmlProvider
extends BaseProvider<GetResultList> {
    public GetResultListHtmlProvider() {
        super(GetResultList.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    protected String getContent(GetResultList proxy) {
        String result = ProviderUtil.getHtmlHeader();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(Util.getName(this.uriInfo.getPath(), '/')));
        result = result + "<h1>" + typeKey + "</h1>";
        String postCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("POST"), "POST", "Create", this.uriInfo);
        result = ProviderUtil.getHtmlForComponent(postCommand, "Create " + typeKey, result);
        String childResourceLinks = this.getResourcesLinks(proxy.getDomList(), proxy.getCommandResourcesPaths());
        result = ProviderUtil.getHtmlForComponent(childResourceLinks, "Child Resources", result);
        result = result + "</html></body>";
        return result;
    }

    private String getResourcesLinks(List<Dom> proxyList, String[][] commandResourcesPaths) {
        String result = "";
        for (Dom proxy : proxyList) {
            try {
                result = result + "<a href=\"" + ProviderUtil.getElementLink(this.uriInfo, proxy.getKey()) + "\">";
                result = result + proxy.getKey();
                result = result + "</a>";
                result = result + "<br>";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String[] commandResourcePath : commandResourcesPaths) {
            try {
                result = result + "<a href=\"" + ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0]) + "\">";
                result = result + commandResourcePath[0];
                result = result + "</a>";
                result = result + "<br>";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!result.equals("")) {
            result = "<div>" + result + "</div>" + "<br>";
        }
        return result;
    }
}

