/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.Stats;
import org.glassfish.flashlight.datatree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class TreeNodeJsonProvider
extends BaseProvider<List<TreeNode>> {
    public TreeNodeJsonProvider() {
        super(List.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if ("java.util.List<org.glassfish.flashlight.datatree.TreeNode>".equals(genericType.toString())) {
            return mediaType.isCompatible(this.supportedMediaType);
        }
        return false;
    }

    @Override
    protected String getContent(List<TreeNode> proxy) {
        String indent = "  ";
        String result = "{";
        result = result + "\n\n" + indent;
        result = result + ProviderUtil.quote(ProviderUtil.getTypeKey(Util.getName(this.uriInfo.getPath(), '/'))) + ":{";
        if (proxy.isEmpty() && this.uriInfo.getPath().equalsIgnoreCase("domain")) {
            result = result + ProviderUtil.getHint(this.uriInfo, "application/json");
        }
        result = result + this.getAttributes(proxy, indent + "  ");
        result = result + "},";
        result = result + "\n\n" + indent;
        result = result + ProviderUtil.quote(ProviderUtil.getResourcesKey());
        result = result + ":[";
        result = result + this.getResourcesLinks(proxy, indent + "  ");
        result = result + "\n" + indent + "]";
        result = result + "\n\n" + "}";
        return result;
    }

    private String getAttributes(List<TreeNode> nodeList, String indent) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (node.hasChildNodes()) continue;
            result = result + this.jsonForNodeValue(node.getName(), node.getValue(), indent);
        }
        int endIndex = result.length() - 1;
        if (endIndex > 0) {
            result = result.substring(0, endIndex);
        }
        return result;
    }

    private String getResourcesLinks(List<TreeNode> nodeList, String indent) {
        String result = "";
        for (TreeNode node : nodeList) {
            if (!node.hasChildNodes()) continue;
            try {
                String elementName = node.getName();
                result = result + "\n" + indent;
                result = result + ProviderUtil.quote(ProviderUtil.getElementLink(this.uriInfo, elementName));
                result = result + ",";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int endIndex = result.length() - 1;
        if (endIndex > 0) {
            result = result.substring(0, endIndex);
        }
        return result;
    }

    private String jsonForNodeValue(String name, Object value, String indent) {
        String result = "";
        if (value == null) {
            return result;
        }
        try {
            if (value instanceof Statistic) {
                Statistic statisticObject = (Statistic)value;
                result = result + this.getStatisticRepresentation(statisticObject);
                result = "\n" + indent + ProviderUtil.quote(name) + ":" + "{" + result + "}";
                result = result + ",";
                return result;
            }
            if (value instanceof Stats) {
                for (Statistic statistic : ((Stats)value).getStatistics()) {
                    String statResult = this.getStatisticRepresentation(statistic);
                    if (statResult.equals("")) continue;
                    statResult = "\n" + indent + indent + ProviderUtil.quote(statistic.getName()) + ":" + "{" + statResult + "}";
                    result = result + statResult;
                    result = result + ",";
                    statResult = "";
                }
                int endIndex = result.length() - 1;
                if (endIndex > 0) {
                    result = result.substring(0, endIndex);
                }
                result = "\n" + indent + ProviderUtil.quote(name) + ":" + "{" + result + "}";
                result = result + ",";
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = " " + ProviderUtil.quote(name) + ":" + ProviderUtil.jsonValue(value);
        result = result + ",";
        return result;
    }

    private String getStatisticRepresentation(Statistic statistic) throws IllegalAccessException, InvocationTargetException {
        String result = "";
        Map<String, Object> map = ProviderUtil.getStatistic(statistic);
        Set<String> attributes = map.keySet();
        for (String attributeName : attributes) {
            Object attributeValue = map.get(attributeName);
            result = result + " " + ProviderUtil.quote(attributeName) + ":" + ProviderUtil.jsonValue(attributeValue);
            result = result + ",";
        }
        int endIndex = result.length() - 1;
        if (endIndex > 0) {
            result = result.substring(0, endIndex);
        }
        return result;
    }
}

