/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.GeneratorException;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.generator.TextClassWriter;

public class TextResourcesGenerator
extends ResourcesGeneratorBase {
    private static String GENERATOR_OUTPUT_DIR = System.getProperty("user.home") + "/src/glassfish/v3/admin/rest/src/main/java/org/glassfish/admin/rest/resources/generated.new";
    private File generationDir = new File(GENERATOR_OUTPUT_DIR);

    public TextResourcesGenerator() {
        this.generationDir.mkdirs();
    }

    public ClassWriter getClassWriter(String className, String baseClassName, String resourcePath) {
        TextClassWriter writer = null;
        try {
            writer = new TextClassWriter(this.generationDir, className, baseClassName, resourcePath);
        }
        catch (IOException e) {
            Logger.getLogger(TextResourcesGenerator.class.getName()).log(Level.SEVERE, e.getMessage());
            throw new GeneratorException(e);
        }
        return writer;
    }

    public String endGeneration() {
        File file = new File(this.generationDir + "/codegeneration.properties");
        try {
            file.createNewFile();
            FileWriter fstream = new FileWriter(file);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write("generation_date=" + new Date() + "\n");
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Code Generation done at : " + this.generationDir;
    }
}

