/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class ActionReportResultHtmlProvider
extends BaseProvider<ActionReportResult> {
    public ActionReportResultHtmlProvider() {
        super(ActionReportResult.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    protected String getContent(ActionReportResult proxy) {
        String result = ProviderUtil.getHtmlHeader();
        String uri = this.uriInfo.getAbsolutePath().toString();
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        String parentName = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getParentName(uri)));
        result = result + "<h1>" + name + "</h1>";
        if (proxy.isError()) {
            result = result + "<h2>Error:</h2>";
            result = result + proxy.getErrorMessage() + "<br>";
        } else {
            result = result + "<h2>" + parentName + " - " + name + "</h2>";
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                proxy.getActionReport().writeReport((OutputStream)baos);
                result = result + baos.toString() + "<br>";
            }
            catch (IOException ex) {
                Logger.getLogger(ActionReportResultHtmlProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        result = "<div>" + result + "</div>" + "<br>";
        result = result + "</body></html>";
        return result;
    }
}

