/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.List;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResult;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class GetResultHtmlProvider
extends BaseProvider<GetResult> {
    public GetResultHtmlProvider() {
        super(GetResult.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    protected String getContent(GetResult proxy) {
        String result = ProviderUtil.getHtmlHeader();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(Util.getName(this.uriInfo.getAbsolutePath().toString(), '/')));
        result = result + "<h1>" + typeKey + "</h1>";
        String attributes = ProviderUtil.getHtmlRespresentationForAttributes((ConfigBean)proxy.getDom(), this.uriInfo);
        result = ProviderUtil.getHtmlForComponent(attributes, "Attributes", result);
        String deleteCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("DELETE"), "DELETE", "Delete", this.uriInfo);
        result = ProviderUtil.getHtmlForComponent(deleteCommand, "Delete " + typeKey, result);
        String childResourceLinks = this.getResourcesLinks(proxy.getDom());
        result = ProviderUtil.getHtmlForComponent(childResourceLinks, "Child Resources", result);
        String commandLinks = this.getCommandLinks(proxy.getCommandResourcesPaths());
        result = ProviderUtil.getHtmlForComponent(commandLinks, "Commands", result);
        result = result + "</body></html>";
        return result;
    }

    private String getResourcesLinks(Dom proxy) {
        StringBuilder result = new StringBuilder("<div>");
        Set elementNames = proxy.model.getElementNames();
        if (elementNames.isEmpty() && "applications".equals(Util.getName(this.uriInfo.getPath(), '/'))) {
            elementNames.add("application");
        }
        for (String elementName : elementNames) {
            if (elementName.equals("*")) {
                ConfigModel.Node node = (ConfigModel.Node)proxy.model.getElement(elementName);
                ConfigModel childModel = node.getModel();
                try {
                    Class<?> subType = ((ClassLoader)childModel.classLoaderHolder.get()).loadClass(childModel.targetTypeName);
                    List lcm = proxy.document.getAllModelsImplementing(subType);
                    if (lcm == null) continue;
                    for (ConfigModel cmodel : lcm) {
                        result.append("<a href=\"").append(ProviderUtil.getElementLink(this.uriInfo, cmodel.getTagName())).append("\">").append(cmodel.getTagName()).append("</a><br>");
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            result.append("<a href=\"").append(ProviderUtil.getElementLink(this.uriInfo, elementName)).append("\">").append(elementName).append("</a><br>");
        }
        return result.append("</div><br>").toString();
    }

    private String getCommandLinks(String[][] commandResourcesPaths) {
        StringBuilder result = new StringBuilder("<div>");
        for (String[] commandResourcePath : commandResourcesPaths) {
            if (commandResourcePath[2].startsWith("_")) {
                result.append("<!--");
            }
            result.append("<a href=\"").append(ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0])).append("\">").append(commandResourcePath[0]).append("</a><br>");
            if (!commandResourcePath[2].startsWith("_")) continue;
            result.append("-->");
        }
        return result.append("</div><br>").toString();
    }
}

