/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.logviewer.LogViewerResource;
import org.glassfish.admin.rest.resources.TemplateResource;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.results.StringListResult;
import org.glassfish.external.amx.AMXGlassfish;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Dom;

public class GlassFishDomainResource
extends TemplateResource {
    public Dom getEntity() {
        return RestService.getDomainBean();
    }

    @Path(value="view-log/")
    public LogViewerResource getViewLogResource() {
        LogViewerResource resource = (LogViewerResource)this.resourceContext.getResource(LogViewerResource.class);
        return resource;
    }

    @GET
    @Path(value="jmx-urls/")
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public StringListResult getJmxServiceUrl() {
        try {
            Habitat habitat = RestService.getHabitat();
            MBeanServer mBeanServer = (MBeanServer)habitat.getComponent(MBeanServer.class);
            JMXServiceURL[] urls = (JMXServiceURL[])mBeanServer.getAttribute(AMXGlassfish.DEFAULT.getBootAMXMBeanObjectName(), "JMXServiceURLs");
            ArrayList<String> jmxUrls = new ArrayList<String>();
            for (JMXServiceURL url : urls) {
                jmxUrls.add(url.getURLPath());
            }
            return new StringListResult("jmx-service-urls", jmxUrls, "", "", new OptionsResult());
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }
}

