/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.results.OptionsResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
public class OptionsResultJsonProvider
extends BaseProvider<OptionsResult> {
    private static final String NAME = "name";
    private static final String QUERY_PARAMETERS = "queryParameters";
    private static final String MESSAGE_PARAMETERS = "messageParameters";

    public OptionsResultJsonProvider() {
        super(OptionsResult.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected String getContent(OptionsResult proxy) {
        JSONObject obj = new JSONObject();
        try {
            obj.put(proxy.getName(), (Object)this.getRespresenationForMethodMetaData(proxy));
        }
        catch (JSONException ex) {
            Logger.getLogger(OptionsResultJsonProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return obj.toString();
    }

    public JSONArray getRespresenationForMethodMetaData(OptionsResult proxy) {
        JSONArray arr = new JSONArray();
        Set<String> methods = proxy.methods();
        Iterator<String> iterator = methods.iterator();
        while (iterator.hasNext()) {
            try {
                String methodName = iterator.next();
                MethodMetaData methodMetaData = proxy.getMethodMetaData(methodName);
                JSONObject method = new JSONObject();
                method.put(NAME, (Object)methodName);
                method.put(QUERY_PARAMETERS, (Object)this.getQueryParams(methodMetaData));
                method.put(MESSAGE_PARAMETERS, (Object)this.getMessageParams(methodMetaData));
                arr.put((Object)method);
            }
            catch (JSONException ex) {
                Logger.getLogger(OptionsResultJsonProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return arr;
    }

    private JSONObject getQueryParams(MethodMetaData methodMetaData) throws JSONException {
        JSONObject obj = new JSONObject();
        if (methodMetaData.sizeQueryParamMetaData() > 0) {
            Set<String> queryParams = methodMetaData.queryParams();
            for (String queryParam : queryParams) {
                ParameterMetaData parameterMetaData = methodMetaData.getQueryParamMetaData(queryParam);
                obj.put(queryParam, (Object)this.getParameter(parameterMetaData));
            }
        }
        return obj;
    }

    private JSONObject getParameter(ParameterMetaData parameterMetaData) throws JSONException {
        JSONObject result = new JSONObject();
        for (String attributeName : parameterMetaData.attributes()) {
            result.put(attributeName, (Object)parameterMetaData.getAttributeValue(attributeName));
        }
        return result;
    }

    private JSONObject getMessageParams(MethodMetaData methodMetaData) throws JSONException {
        JSONObject result = new JSONObject();
        if (methodMetaData.sizeParameterMetaData() > 0) {
            Set<String> parameters = methodMetaData.parameters();
            for (String parameter : parameters) {
                ParameterMetaData parameterMetaData = methodMetaData.getParameterMetaData(parameter);
                result.put(parameter, (Object)this.getParameter(parameterMetaData));
            }
        }
        return result;
    }
}

