/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.GetResultList;
import org.glassfish.admin.rest.utils.DomConfigurator;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class GetResultListHtmlProvider
extends BaseProvider<GetResultList> {
    public GetResultListHtmlProvider() {
        super(GetResultList.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    protected String getContent(GetResultList proxy) {
        String result = ProviderUtil.getHtmlHeader();
        String typeKey = Util.upperCaseFirstLetter(Util.decode(Util.getName(this.uriInfo.getPath(), '/')));
        result = result + "<h1>" + typeKey + "</h1>";
        String postCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("POST"), "POST", "Create", this.uriInfo);
        result = ProviderUtil.getHtmlForComponent(postCommand, "Create " + typeKey, result);
        String childResourceLinks = this.getResourcesLinks(proxy.getDomList());
        result = ProviderUtil.getHtmlForComponent(childResourceLinks, "Child Resources", result);
        String commandLinks = this.getCommandLinks(proxy.getCommandResourcesPaths());
        result = ProviderUtil.getHtmlForComponent(commandLinks, "Commands", result);
        result = result + "</html></body>";
        return result;
    }

    private String getResourcesLinks(List<Dom> proxyList) {
        StringBuilder result = new StringBuilder("<div>");
        Collections.sort(proxyList, new DomConfigurator());
        for (Map.Entry<String, String> link : this.getResourceLinks(proxyList).entrySet()) {
            result.append("<a href=\"").append(link.getValue()).append("\">").append(link.getKey()).append("</a><br>");
        }
        result.append("</div><br/>");
        return result.toString();
    }

    private String getCommandLinks(String[][] commandResourcesPaths) {
        StringBuilder result = new StringBuilder("<div>");
        for (String[] commandResourcePath : commandResourcesPaths) {
            try {
                result.append("<a href=\"").append(ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0])).append("\">").append(commandResourcePath[0]).append("</a><br/>");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        result.append("</div><br/>");
        return result.toString();
    }
}

