/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.glassfish.admin.rest.generator.ClassWriter;
import org.glassfish.admin.rest.generator.CommandResourceMetaData;
import org.glassfish.admin.rest.generator.GeneratorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextClassWriter
implements ClassWriter {
    Writer writer;

    public TextClassWriter(File generationDir, String className, String baseClassName, String resourcePath) throws IOException {
        File file = new File(generationDir, className + ".java");
        file.createNewFile();
        FileWriter fstream = new FileWriter(file);
        this.writer = new BufferedWriter(fstream);
        this.writeCopyRightHeader();
        this.writePackageHeader();
        this.writeImportStatements();
        if (resourcePath != null) {
            this.writer.write("@Path(\"/" + resourcePath + "/\")\n");
        }
        this.writer.write("public class " + className + " extends " + baseClassName + "  {\n\n");
    }

    private void writePackageHeader() throws IOException {
        this.writer.write("package org.glassfish.admin.rest.resources.generated;\n");
    }

    private void writeCopyRightHeader() throws IOException {
        this.writer.write("/*\n");
        this.writer.write(" * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.\n");
        this.writer.write(" *\n");
        this.writer.write(" * Copyright 2009-2010 Sun Microsystems, Inc. All rights reserved.\n");
        this.writer.write(" *\n");
        this.writer.write(" * The contents of this file are subject to the terms of either the GNU\n");
        this.writer.write(" * General Public License Version 2 only (\"GPL\") or the Common Development\n");
        this.writer.write(" * and Distribution License(\"CDDL\") (collectively, the \"License\").  You\n");
        this.writer.write(" * may not use this file except in compliance with the License. You can obtain\n");
        this.writer.write(" * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html\n");
        this.writer.write(" * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific\n");
        this.writer.write(" * language governing permissions and limitations under the License.\n");
        this.writer.write(" *\n");
        this.writer.write(" * When distributing the software, include this License Header Notice in each\n");
        this.writer.write(" * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.\n");
        this.writer.write(" * Sun designates this particular file as subject to the \"Classpath\" exception\n");
        this.writer.write(" * as provided by Sun in the GPL Version 2 section of the License file that\n");
        this.writer.write(" * accompanied this code.  If applicable, add the following below the License\n");
        this.writer.write(" * Header, with the fields enclosed by brackets [] replaced by your own\n");
        this.writer.write(" * identifying information: \"Portions Copyrighted [year]\n");
        this.writer.write(" * [name of copyright owner]\"\n");
        this.writer.write(" *\n");
        this.writer.write(" * Contributor(s):\n");
        this.writer.write(" *\n");
        this.writer.write(" * If you wish your version of this file to be governed by only the CDDL or\n");
        this.writer.write(" * only the GPL Version 2, indicate your decision by adding \"[Contributor]\n");
        this.writer.write(" * elects to include this software in this distribution under the [CDDL or GPL\n");
        this.writer.write(" * Version 2] license.\"  If you don't indicate a single choice of license, a\n");
        this.writer.write(" * recipient has the option to distribute your version of this file under\n");
        this.writer.write(" * either the CDDL, the GPL Version 2 or to extend the choice of license to\n");
        this.writer.write(" * its licensees as provided above.  However, if you add GPL Version 2 code\n");
        this.writer.write(" * and therefore, elected the GPL Version 2 license, then the option applies\n");
        this.writer.write(" * only if the new code is made subject to such option by the copyright\n");
        this.writer.write(" * holder.\n");
        this.writer.write(" */\n");
    }

    private void writeImportStatements() throws IOException {
        this.writer.write("import javax.ws.rs.Path;\n");
        this.writer.write("import javax.ws.rs.PathParam;\n");
        this.writer.write("import org.glassfish.admin.rest.resources.*;\n");
        this.writer.write("import org.glassfish.admin.rest.resources.custom.*;\n");
    }

    @Override
    public void createCommandResourceConstructor(String commandResourceClassName, String commandName, String httpMethod, boolean linkedToParent, CommandResourceMetaData.ParameterMetaData[] commandParams, String commandDisplayName, String commandAction) {
        try {
            this.writer.write("   public " + commandResourceClassName + "() {\n");
            this.writer.write("       super(\n");
            this.writer.write("          \"" + commandResourceClassName + "\",\n");
            this.writer.write("          \"" + commandName + "\",\n");
            this.writer.write("          \"" + httpMethod + "\",\n");
            if (!httpMethod.equals("GET")) {
                this.writer.write("          \"" + commandAction + "\",\n");
                this.writer.write("          \"" + commandDisplayName + "\",\n");
            }
            this.writer.write("          " + linkedToParent + ");\n");
            this.writer.write("    }\n");
            if (commandParams != null) {
                this.writer.write("@Override\n");
                this.writer.write("protected java.util.HashMap<String, String> getCommandParams() {\n");
                this.writer.write("\tjava.util.HashMap<String, String> hm = new java.util.HashMap<String, String>();\n");
                for (CommandResourceMetaData.ParameterMetaData commandParam : commandParams) {
                    this.writer.write("\thm.put(\"" + commandParam.name + "\",\"" + commandParam.value + "\");\n");
                }
                this.writer.write("\treturn hm;\n");
                this.writer.write("}\n");
            }
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetCommandResource(String commandResourceClassName, String resourcePath) {
        try {
            this.writer.write("@Path(\"" + resourcePath + "/\")\n");
            this.writer.write("public " + commandResourceClassName + " get" + commandResourceClassName + "() {\n");
            this.writer.write(commandResourceClassName + " resource = resourceContext.getResource(" + commandResourceClassName + ".class);\n");
            this.writer.write("return resource;\n");
            this.writer.write("}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createCustomResourceMapping(String resourceClassName, String mappingPath) {
        try {
            this.writer.write("\n");
            this.writer.write("\t@Path(\"" + mappingPath + "/\")\n");
            this.writer.write("\tpublic " + resourceClassName + " get" + resourceClassName + "() {\n");
            this.writer.write("\t\t" + resourceClassName + " resource = resourceContext.getResource(" + resourceClassName + ".class);\n");
            this.writer.write("\t\tresource.setEntity(getEntity());\n");
            this.writer.write("\t\treturn resource;\n");
            this.writer.write("\t}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetCommandResourcePaths(List<CommandResourceMetaData> commandMetaData) {
        assert (commandMetaData.size() > 0) : "It is assumed that this method is called only if commandMetaData.size() > 0";
        try {
            this.writer.write("@Override\n");
            this.writer.write("public String[][] getCommandResourcesPaths() {\n");
            StringBuilder commandResourcesPaths = new StringBuilder();
            for (CommandResourceMetaData metaData : commandMetaData) {
                if (commandResourcesPaths.length() > 0) {
                    commandResourcesPaths = commandResourcesPaths.append(", ");
                }
                commandResourcesPaths = commandResourcesPaths.append("{").append('\"').append(metaData.resourcePath).append("\", ").append('\"').append(metaData.httpMethod).append("\", ").append('\"').append(metaData.command).append("\"} ");
            }
            this.writer.write("return new String[][] {" + commandResourcesPaths + "};\n");
            this.writer.write("}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetDeleteCommand(String commandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("public String getDeleteCommand() {\n");
            this.writer.write("\treturn \"" + commandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetPostCommand(String commandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("public String getPostCommand() {\n");
            this.writer.write("\treturn \"" + commandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetChildResource(String path, String childResourceClassName) {
        try {
            this.writer.write("\t@Path(\"" + path + "/\")\n");
            this.writer.write("\tpublic " + childResourceClassName + " get" + childResourceClassName + "() {\n");
            this.writer.write("\t\t" + childResourceClassName + " resource = resourceContext.getResource(" + childResourceClassName + ".class);\n");
            this.writer.write("\t\tresource.setParentAndTagName(getEntity() , \"" + path + "\");\n");
            this.writer.write("\t\treturn resource;\n");
            this.writer.write("\t}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetChildResourceForListResources(String keyAttributeName, String childResourceClassName) {
        try {
            this.writer.write("\n");
            this.writer.write("\t@Path(\"{" + keyAttributeName + "}/\")\n");
            this.writer.write("\tpublic " + childResourceClassName + " get" + childResourceClassName + "(@PathParam(\"" + keyAttributeName + "\") String id) {\n");
            this.writer.write("\t\t" + childResourceClassName + " resource = resourceContext.getResource(" + childResourceClassName + ".class);\n");
            this.writer.write("\t\tresource.setBeanByKey(entity, id);\n");
            this.writer.write("\t\treturn resource;\n");
            this.writer.write("\t}\n\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetPostCommandForCollectionLeafResource(String postCommandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("protected String getPostCommand(){\n");
            this.writer.write("return \"" + postCommandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetDeleteCommandForCollectionLeafResource(String deleteCommandName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("protected String getDeleteCommand(){\n");
            this.writer.write("return \"" + deleteCommandName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void createGetDisplayNameForCollectionLeafResource(String displayName) {
        try {
            this.writer.write("@Override\n");
            this.writer.write("protected String getName(){\n");
            this.writer.write("return \"" + displayName + "\";\n");
            this.writer.write("}\n");
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }

    @Override
    public void done() {
        try {
            this.writer.write("}\n");
            this.writer.close();
        }
        catch (IOException e) {
            throw new GeneratorException(e);
        }
    }
}

