/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.v3.common.ActionReporter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.jvnet.hk2.config.ConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class ActionReportResultHtmlProvider
extends BaseProvider<ActionReportResult> {
    public ActionReportResultHtmlProvider() {
        super(ActionReportResult.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    public String getContent(ActionReportResult proxy) {
        RestActionReporter ar = (RestActionReporter)proxy.getActionReport();
        StringBuilder result = new StringBuilder(ProviderUtil.getHtmlHeader());
        result.append("<h1>").append(ar.getActionDescription()).append("</h1><div>");
        if (proxy.isError()) {
            result.append("<h2>Error:</h2>").append(proxy.getErrorMessage());
        } else {
            ConfigBean entity = proxy.getEntity();
            Map childResources = (Map)ar.getExtraProperties().get("childResources");
            List commands = (List)ar.getExtraProperties().get("commands");
            MethodMetaData postMetaData = proxy.getMetaData().getMethodMetaData("POST");
            if (postMetaData != null && entity == null) {
                String postCommand = ProviderUtil.getHtmlRespresentationsForCommand(postMetaData, "POST", "Create", this.uriInfo);
                result.append(ProviderUtil.getHtmlForComponent(postCommand, "Create " + ar.getActionDescription(), ""));
            }
            if (entity != null) {
                String attributes = ProviderUtil.getHtmlRepresentationForAttributes(proxy.getEntity(), this.uriInfo);
                result.append(ProviderUtil.getHtmlForComponent(attributes, "Attributes", ""));
                String deleteCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("DELETE"), "DELETE", "Delete", this.uriInfo);
                result.append(ProviderUtil.getHtmlForComponent(deleteCommand, "Delete " + entity.model.getTagName(), ""));
            }
            if (childResources != null) {
                String childResourceLinks = this.getResourcesLinks(childResources);
                result.append(ProviderUtil.getHtmlForComponent(childResourceLinks, "Child Resources", ""));
            }
            if (commands != null) {
                String commandLinks = this.getCommandLinks(commands);
                result.append(ProviderUtil.getHtmlForComponent(commandLinks, "Commands", ""));
            }
            result.append("<h2>Raw Output</h2>");
            result.append(this.processReport(ar));
        }
        return result.append("</div></body></html>").toString();
    }

    protected String getResourcesLinks(Map<String, String> childResources) {
        StringBuilder links = new StringBuilder("<div>");
        for (Map.Entry<String, String> link : childResources.entrySet()) {
            links.append("<a href=\"").append(link.getValue()).append("\">").append(link.getKey()).append("</a><br>");
        }
        return links.append("</div><br/>").toString();
    }

    protected String getCommandLinks(List<Map<String, String>> commands) {
        StringBuilder result = new StringBuilder("<div>");
        for (Map<String, String> commandList : commands) {
            String command = commandList.get("command");
            String path = commandList.get("path");
            if (path.startsWith("_")) {
                result.append("<!--");
            }
            result.append("<a href=\"").append(ProviderUtil.getElementLink(this.uriInfo, command)).append("\">").append(command).append("</a><br>");
            if (!path.startsWith("_")) continue;
            result.append("-->");
        }
        return result.append("</div><br>").toString();
    }

    protected String processReport(ActionReporter ar) {
        List subReports;
        List children;
        Properties extraProperties;
        StringBuilder result = new StringBuilder();
        result.append("<h1>GlassFish ").append(ar.getActionDescription()).append(" command report</h1><h2>").append(ar.getMessage() != null ? ar.getMessage() : "").append("</h2><h2>Exit Code: ").append(ar.getActionExitCode().toString()).append("</h2><hr>");
        Properties properties = ar.getTopMessagePart().getProps();
        if (!properties.isEmpty()) {
            result.append(this.processProperties(properties));
        }
        if ((extraProperties = ar.getExtraProperties()) != null && !extraProperties.isEmpty()) {
            result.append(this.getExtraProperties(extraProperties));
        }
        if ((children = ar.getTopMessagePart().getChildren()).size() > 0) {
            result.append(this.processChildren(children));
        }
        if ((subReports = ar.getSubActionsReport()).size() > 0) {
            result.append(this.processSubReports(subReports));
        }
        return result.toString();
    }

    protected String processProperties(Properties props) {
        StringBuilder result = new StringBuilder("<h3>Properties</h3>");
        result.append(this.processMap(props));
        return result.append("</table>").toString();
    }

    protected String getExtraProperties(Properties props) {
        StringBuilder result = new StringBuilder("<h3>Extra Properties</h3>");
        result.append(this.processMap(props));
        return result.toString();
    }

    protected String processChildren(List<ActionReport.MessagePart> parts) {
        StringBuilder result = new StringBuilder("<h3>Children</h3><ul>");
        for (ActionReport.MessagePart part : parts) {
            result.append("<li><table border=\"1\" style=\"border-collapse: collapse\">").append("<tr><td>Message</td>").append("<td>").append(part.getMessage()).append("</td></tr><td>Properites</td><td>").append(this.processMap(part.getProps())).append("</td></tr>");
            List children = part.getChildren();
            if (children.size() > 0) {
                result.append("<tr><td>Children</td><td>").append(this.processChildren(part.getChildren())).append("</td></tr>");
            }
            result.append("</table></li>");
        }
        return result.append("</ul>").toString();
    }

    protected String processSubReports(List<ActionReporter> subReports) {
        StringBuilder result = new StringBuilder("<h3>Sub Reports</h3><ul>");
        for (ActionReporter subReport : subReports) {
            result.append(this.processReport(subReport));
        }
        return result.append("</ul>").toString();
    }

    protected String getHtmlRepresentation(Object object) {
        String result = null;
        if (object == null) {
            return "";
        }
        result = object instanceof Collection ? this.processCollection((Collection)object) : (object instanceof Map ? this.processMap((Map)object) : object.toString());
        return result;
    }

    protected String processCollection(Collection c) {
        StringBuilder result = new StringBuilder("<ul>");
        Iterator i = c.iterator();
        while (i.hasNext()) {
            result.append("<li>").append(this.getHtmlRepresentation(i.next())).append("</li>");
        }
        return result.append("</li></ul>").toString();
    }

    protected String processMap(Map map) {
        StringBuilder result = new StringBuilder("<table border=\"1\" style=\"border-collapse: collapse\">");
        result.append("<tr><th>key</th><th>value</th></tr>");
        for (Map.Entry entry : map.entrySet()) {
            result.append("<tr><td>").append(entry.getKey()).append("</td><td>").append(this.getHtmlRepresentation(entry.getValue())).append("</td></tr>");
        }
        return result.append("</table>").toString();
    }
}

