/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.StringListResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class StringListResultHtmlProvider
extends BaseProvider<StringListResult> {
    public StringListResultHtmlProvider() {
        super(StringListResult.class, MediaType.TEXT_HTML_TYPE);
    }

    @Override
    public String getContent(StringListResult proxy) {
        String result = ProviderUtil.getHtmlHeader();
        String uri = this.uriInfo.getAbsolutePath().toString();
        String name = Util.upperCaseFirstLetter(Util.eleminateHypen(Util.getName(uri, '/')));
        result = result + "<h1>" + name + "</h1>";
        if (proxy.isError()) {
            result = result + "<h2>Error:</h2>";
            result = result + proxy.getErrorMessage() + "<br>";
        } else {
            result = result + "<h2>" + proxy.getName() + "</h2>";
            for (String message : proxy.getMessages()) {
                result = result + message + "<br>";
            }
        }
        result = "<div>" + result + "</div>" + "<br>";
        String command = proxy.getPostCommand();
        if (command != null) {
            String postCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("POST"), "POST", "Create", this.uriInfo);
            result = ProviderUtil.getHtmlForComponent(postCommand, "Create " + proxy.getName(), result);
        }
        if ((command = proxy.getDeleteCommand()) != null) {
            String deleteCommand = ProviderUtil.getHtmlRespresentationsForCommand(proxy.getMetaData().getMethodMetaData("DELETE"), "DELETE", "Delete", this.uriInfo);
            result = ProviderUtil.getHtmlForComponent(deleteCommand, "Delete " + proxy.getName(), result);
        }
        result = result + "</body></html>";
        return result;
    }
}

