/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.logviewer.LogViewerResource;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.resources.TemplateResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishDomainResource
extends TemplateResource {
    public GlassFishDomainResource() {
        this.childModel = RestService.getDomainBean().model;
        this.entity = RestService.getDomainBean();
    }

    @Path(value="view-log/")
    public LogViewerResource getViewLogResource() {
        LogViewerResource resource = (LogViewerResource)this.resourceContext.getResource(LogViewerResource.class);
        return resource;
    }

    @GET
    @Path(value="jmx-urls/")
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult getJmxServiceUrl() {
        try {
            Habitat habitat = RestService.getHabitat();
            MBeanServer mBeanServer = (MBeanServer)habitat.getComponent(MBeanServer.class);
            JMXServiceURL[] urls = (JMXServiceURL[])mBeanServer.getAttribute(this.getBootAMXMBeanObjectName(), "JMXServiceURLs");
            ArrayList<String> jmxUrls = new ArrayList<String>();
            for (JMXServiceURL url : urls) {
                jmxUrls.add(url.getURLPath());
            }
            RestActionReporter ar = new RestActionReporter();
            ar.setActionDescription("Get JMX Service URLs");
            ar.setSuccess();
            ar.getExtraProperties().put("jmxServiceUrls", jmxUrls);
            return new ActionReportResult(ar);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName getBootAMXMBeanObjectName() {
        try {
            return new ObjectName("amx-support:type=boot-amx");
        }
        catch (Exception e) {
            throw new RuntimeException("bad ObjectName", e);
        }
    }

    @POST
    @Path(value="set/")
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult setDomainConfig(HashMap<String, String> data) {
        TemplateExecCommand resource = new TemplateExecCommand("DomainResource", "set", "POST", "commandAction", "set", false);
        resource.requestHeaders = this.requestHeaders;
        Iterator<Map.Entry<String, String>> iterator = data.entrySet().iterator();
        if (iterator.hasNext()) {
            ParameterMap fixed = new ParameterMap();
            Map.Entry<String, String> entry = iterator.next();
            fixed.add((Object)"DEFAULT", (Object)(entry.getKey() + "=" + entry.getValue()));
            return resource.executeCommand(fixed);
        }
        throw new RuntimeException("You must supply exactly one configuration option.");
    }
}

