/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionManager {
    private static SessionManager theSessionManager = new SessionManager();
    private final SecureRandom randomGenerator = new SecureRandom();
    private Map<String, SessionData> activeSessions = new ConcurrentHashMap<String, SessionData>();

    private SessionManager() {
    }

    public static SessionManager getSessionManager() {
        return theSessionManager;
    }

    public String createSession(GrizzlyRequest req) {
        String sessionId;
        while (this.isSessionExist(sessionId = new BigInteger(130, this.randomGenerator).toString(16))) {
        }
        this.saveSession(sessionId, req);
        return sessionId;
    }

    public boolean authenticate(String sessionId, GrizzlyRequest req) {
        SessionData sessionData;
        boolean authenticated = false;
        if (sessionId != null && (sessionData = this.activeSessions.get(sessionId)) != null) {
            authenticated = sessionData.authenticate(req);
            if (authenticated) {
                sessionData.updateLastAccessTime();
            } else {
                this.activeSessions.remove(sessionId);
            }
        }
        return authenticated;
    }

    public boolean deleteSession(String sessionId) {
        boolean sessionDeleted = false;
        if (sessionId != null) {
            SessionData removedSession = this.activeSessions.remove(sessionId);
            sessionDeleted = removedSession != null;
        }
        return sessionDeleted;
    }

    private void saveSession(String sessionId, GrizzlyRequest req) {
        this.purgeInactiveSessions();
        this.activeSessions.put(sessionId, new SessionData(sessionId, req));
    }

    private void purgeInactiveSessions() {
        Set<Map.Entry<String, SessionData>> activeSessionsSet = this.activeSessions.entrySet();
        for (Map.Entry<String, SessionData> entry : activeSessionsSet) {
            if (entry.getValue().isSessionActive()) continue;
            activeSessionsSet.remove(entry);
        }
    }

    private boolean isSessionExist(String sessionId) {
        return this.activeSessions.containsKey(sessionId);
    }

    private static class SessionData {
        private static long INACTIVE_SESSION_DEFAULT_LIFETIME_IN_MILIS = 1800000L;
        private String sessionId;
        private String clientAddress;
        private long creationTime;
        private long lassAccessedTime;
        private long inactiveSessionLifeTime;

        public SessionData(String sessionId, GrizzlyRequest req) {
            this.lassAccessedTime = this.creationTime = System.currentTimeMillis();
            this.inactiveSessionLifeTime = INACTIVE_SESSION_DEFAULT_LIFETIME_IN_MILIS;
            this.sessionId = sessionId;
            this.clientAddress = req.getRemoteAddr();
        }

        public boolean isSessionActive() {
            return this.lassAccessedTime + this.inactiveSessionLifeTime > System.currentTimeMillis();
        }

        public void updateLastAccessTime() {
            this.lassAccessedTime = System.currentTimeMillis();
        }

        public boolean authenticate(GrizzlyRequest req) {
            return this.isSessionActive();
        }
    }
}

