/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.config.serverbeans.Config;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestConfig;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.utils.ConfigModelComparator;
import org.glassfish.admin.rest.utils.DomConfigurator;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public abstract class BaseProvider<T>
implements MessageBodyWriter<T> {
    public static final String HEADER_DEBUG = "__debug";
    public static final String JSONP_CALLBACK = "jsoncallback";
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders requestHeaders;
    protected Class desiredType;
    protected MediaType supportedMediaType;

    public BaseProvider(Class desiredType, MediaType mediaType) {
        this.desiredType = desiredType;
        this.supportedMediaType = mediaType;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] antns, MediaType mt) {
        if (this.desiredType.equals(genericType)) {
            return mt.isCompatible(this.supportedMediaType);
        }
        return false;
    }

    public long getSize(T t, Class<?> type, Type type1, Annotation[] antns, MediaType mt) {
        return -1L;
    }

    public void writeTo(T proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getContent(proxy).getBytes());
    }

    public abstract String getContent(T var1);

    protected int getFormattingIndentLevel() {
        if (this.isDebug()) {
            return 4;
        }
        return -1;
    }

    protected boolean isDebug() {
        RestConfig rg;
        Config config = RestService.getDomain().getConfigNamed("server-config");
        if (config != null && (rg = (RestConfig)config.getExtensionByType(RestConfig.class)) != null && rg.getDebug().equalsIgnoreCase("true")) {
            return true;
        }
        if (this.requestHeaders == null) {
            return true;
        }
        List header = this.requestHeaders.getRequestHeader(HEADER_DEBUG);
        return header != null && "true".equals(header.get(0));
    }

    protected String getCallBackJSONP() {
        if (this.uriInfo == null) {
            return null;
        }
        MultivaluedMap l = this.uriInfo.getQueryParameters();
        if (l == null) {
            return null;
        }
        return (String)l.getFirst((Object)JSONP_CALLBACK);
    }

    protected String getXmlCommandLinks(String[][] commandResourcesPaths, String indent) {
        StringBuilder result = new StringBuilder();
        for (String[] commandResourcePath : commandResourcesPaths) {
            result.append("\n").append(indent).append(ProviderUtil.getStartXmlElement("command")).append(ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0])).append(ProviderUtil.getEndXmlElement("command"));
        }
        return result.toString();
    }

    protected Map<String, String> getResourceLinks(Dom dom) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        Set elementNames = dom.model.getElementNames();
        for (String elementName : elementNames) {
            if (elementName.equals("*")) {
                ConfigModel.Node node = (ConfigModel.Node)dom.model.getElement(elementName);
                ConfigModel childModel = node.getModel();
                List<ConfigModel> lcm = ResourceUtil.getRealChildConfigModels(childModel, dom.document);
                Collections.sort(lcm, new ConfigModelComparator());
                if (lcm == null) continue;
                Collections.sort(lcm, new ConfigModelComparator());
                for (ConfigModel cmodel : lcm) {
                    links.put(cmodel.getTagName(), ProviderUtil.getElementLink(this.uriInfo, cmodel.getTagName()));
                }
                continue;
            }
            links.put(elementName, ProviderUtil.getElementLink(this.uriInfo, elementName));
        }
        return links;
    }

    protected Map<String, String> getResourceLinks(List<Dom> proxyList) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        Collections.sort(proxyList, new DomConfigurator());
        for (Dom proxy : proxyList) {
            try {
                links.put(proxy.getKey(), ProviderUtil.getElementLink(this.uriInfo, proxy.getKey()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return links;
    }
}

