/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.spi.container.ContainerRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.admin.rest.CliFailureException;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.resources.generated.SystemPropertyResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class SystemPropertiesCliResource
extends TemplateExecCommand {
    protected static final String TAG_SYSTEM_PROPERTY = "system-property";
    @Context
    protected ResourceContext resourceContext;
    protected Dom entity;

    public SystemPropertiesCliResource() {
        super(SystemPropertiesCliResource.class.getSimpleName(), "", "", "", "", true);
    }

    public void setEntity(Dom p) {
        this.entity = p;
    }

    public Dom getEntity() {
        return this.entity;
    }

    @GET
    public ActionReportResult get() {
        Dom server = this.getEntity();
        ParameterMap data = new ParameterMap();
        this.processCommandParams(data);
        this.addQueryString((MultivaluedMap<String, String>)((ContainerRequest)this.requestHeaders).getQueryParameters(), data);
        this.adjustParameters(data);
        ArrayList properties = new ArrayList();
        RestActionReporter actionReport = new RestActionReporter();
        for (Dom child : server.nodeElements(TAG_SYSTEM_PROPERTY)) {
            HashMap<String, String> property = new HashMap<String, String>();
            property.put("name", child.getKey());
            property.put("value", child.attribute("value"));
            properties.add(property);
        }
        actionReport.getExtraProperties().put("systemProperties", properties);
        if (properties.isEmpty()) {
            actionReport.getTopMessagePart().setMessage("Nothing to list.");
        }
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
        return results;
    }

    @POST
    public ActionReportResult create(HashMap<String, String> data) {
        return this.clearThenSaveProperties(data);
    }

    @PUT
    public ActionReportResult update(HashMap<String, String> data) {
        return this.clearThenSaveProperties(data);
    }

    @Path(value="{Name}/")
    public SystemPropertyResource getSystemPropertyResource(@PathParam(value="Name") String id) {
        Dom parent = this.getEntity();
        for (Dom child : parent.nodeElements(TAG_SYSTEM_PROPERTY)) {
            if (!child.getKey().equals(id)) continue;
            SystemPropertyResource resource = (SystemPropertyResource)this.resourceContext.getResource(SystemPropertyResource.class);
            resource.setEntity(child);
            return resource;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    protected String convertPropertyMapToString(HashMap<String, String> data) {
        StringBuilder options = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            options.append(sep).append(entry.getKey()).append("=").append(value);
            sep = ":";
        }
        return options.toString();
    }

    protected ActionReportResult clearThenSaveProperties(HashMap<String, String> data) {
        try {
            this.deleteExistingProperties();
            String propertiesString = this.convertPropertyMapToString(data);
            data = new HashMap();
            data.put("DEFAULT", propertiesString);
            data.put("target", this.getParent(this.uriInfo));
            RestActionReporter actionReport = ResourceUtil.runCommand("create-system-properties", data, RestService.getHabitat(), "");
            ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
            ActionReportResult results = new ActionReportResult(this.commandName, actionReport, new OptionsResult());
            if (exitCode == ActionReport.ExitCode.FAILURE) {
                Throwable ex = actionReport.getFailureCause();
                throw ex == null ? new CliFailureException(actionReport.getMessage()) : new CliFailureException(actionReport.getMessage(), ex);
            }
            results.setStatusCode(200);
            return results;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ValidationException) {
                return ResourceUtil.getActionReportResult(400, ex.getMessage(), this.requestHeaders, this.uriInfo);
            }
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected void deleteExistingProperties() throws TransactionFailure {
        Dom parent = this.getEntity();
        for (Dom existingProp : parent.nodeElements(TAG_SYSTEM_PROPERTY)) {
            ConfigSupport.deleteChild((ConfigBean)((ConfigBean)parent), (ConfigBean)((ConfigBean)existingProp));
        }
    }
}

