/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.Util;
import org.glassfish.admin.rest.generator.ResourcesGeneratorBase;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.provider.ParameterMetaData;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ConfigModelComparator;
import org.glassfish.admin.rest.utils.DomConfigurator;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    private static final String QUERY_PARAMETERS = "queryParameters";
    private static final String MESSAGE_PARAMETERS = "messageParameters";
    static final Pattern TOKENIZER;

    private ResourceUtil() {
    }

    public static void adjustParameters(Map<String, String> data) {
        boolean isRenamed;
        if (data != null && !data.containsKey("DEFAULT") && !(isRenamed = ResourceUtil.renameParameter(data, "name", "DEFAULT"))) {
            ResourceUtil.renameParameter(data, "id", "DEFAULT");
        }
    }

    public static void defineDefaultParameters(Map<String, String> data) {
        if (data != null && !data.containsKey("DEFAULT")) {
            ResourceUtil.renameParameter(data, "id", "DEFAULT");
        }
    }

    public static String getCommand(RestRedirect.OpType type, ConfigModel model) {
        Class<?> cbp = null;
        try {
            cbp = ((ClassLoader)model.classLoaderHolder.get()).loadClass(model.targetTypeName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        RestRedirects restRedirects = cbp.getAnnotation(RestRedirects.class);
        if (restRedirects != null) {
            RestRedirect[] values;
            for (RestRedirect r : values = restRedirects.value()) {
                if (!r.opType().equals((Object)type)) continue;
                return r.commandName();
            }
        }
        return null;
    }

    public static RestActionReporter runCommand(String commandName, Map<String, String> parameters, Habitat habitat, String resultType) {
        ParameterMap p = new ParameterMap();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            p.set((Object)entry.getKey(), (Object)entry.getValue());
        }
        return ResourceUtil.runCommand(commandName, p, habitat, resultType);
    }

    public static RestActionReporter runCommand(String commandName, ParameterMap parameters, Habitat habitat, String resultType) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        RestActionReporter ar = new RestActionReporter();
        cr.getCommandInvocation(commandName, (ActionReport)ar).parameters(parameters).execute();
        return ar;
    }

    public static ActionReport runCommand(String commandName, Properties parameters, Habitat habitat, String typeOfResult) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        RestActionReporter ar = new RestActionReporter();
        ParameterMap p = new ParameterMap();
        for (String prop : parameters.stringPropertyNames()) {
            p.set((Object)prop, (Object)parameters.getProperty(prop));
        }
        cr.getCommandInvocation(commandName, (ActionReport)ar).parameters(p).execute();
        return ar;
    }

    public static MethodMetaData getMethodMetaData(String command, Habitat habitat, Logger logger) {
        return ResourceUtil.getMethodMetaData(command, 1, habitat, logger);
    }

    public static MethodMetaData getMethodMetaData(String command, int parameterType, Habitat habitat, Logger logger) {
        return ResourceUtil.getMethodMetaData(command, null, parameterType, habitat, logger);
    }

    public static MethodMetaData getMethodMetaData(String command, HashMap<String, String> commandParamsToSkip, int parameterType, Habitat habitat, Logger logger) {
        MethodMetaData methodMetaData = new MethodMetaData();
        if (command != null) {
            Collection<CommandModel.ParamModel> params = commandParamsToSkip == null ? ResourceUtil.getParamMetaData(command, habitat, logger) : ResourceUtil.getParamMetaData(command, commandParamsToSkip.keySet(), habitat, logger);
            for (CommandModel.ParamModel paramModel : params) {
                Param param = paramModel.getParam();
                ParameterMetaData parameterMetaData = ResourceUtil.getParameterMetaData(paramModel);
                String parameterName = param.primary() ? "id" : paramModel.getName();
                String alias = param.alias();
                if (alias != null && !alias.isEmpty()) {
                    parameterName = alias;
                }
                if (parameterType == 0) {
                    methodMetaData.putQueryParamMetaData(parameterName, parameterMetaData);
                    continue;
                }
                methodMetaData.putParameterMetaData(parameterName, parameterMetaData);
            }
        }
        return methodMetaData;
    }

    public static void resolveParentParamValue(HashMap<String, String> commandParams, UriInfo uriInfo) {
        String parent = Util.getParentName(uriInfo);
        if (parent != null) {
            Set<String> keys = commandParams.keySet();
            for (String key : keys) {
                if (!commandParams.get(key).equals("$parent")) continue;
                commandParams.put(key, parent);
                break;
            }
        }
    }

    public static MethodMetaData getMethodMetaData(ConfigModel configBeanModel) {
        return ResourceUtil.getMethodMetaData(configBeanModel, 1);
    }

    public static MethodMetaData getMethodMetaData(ConfigModel configBeanModel, int parameterType) {
        MethodMetaData methodMetaData = new MethodMetaData();
        Class<?> configBeanProxy = null;
        try {
            configBeanProxy = ((ClassLoader)configBeanModel.classLoaderHolder.get()).loadClass(configBeanModel.targetTypeName);
            Set attributeNames = configBeanModel.getAttributeNames();
            for (String attributeName : attributeNames) {
                String methodName = ResourceUtil.getAttributeMethodName(attributeName);
                try {
                    Method method = configBeanProxy.getMethod(methodName, new Class[0]);
                    Attribute attribute = method.getAnnotation(Attribute.class);
                    if (attribute == null) continue;
                    ParameterMetaData parameterMetaData = ResourceUtil.getParameterMetaData(attribute);
                    Deprecated dep = method.getAnnotation(Deprecated.class);
                    if (dep != null) {
                        parameterMetaData.putAttribute("deprecated", "true");
                    }
                    attributeName = Util.eleminateHypen(attributeName);
                    if (parameterType == 0) {
                        methodMetaData.putQueryParamMetaData(attributeName, parameterMetaData);
                        continue;
                    }
                    methodMetaData.putParameterMetaData(attributeName, parameterMetaData);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return methodMetaData;
    }

    public static MethodMetaData getMethodMetaData2(Dom parent, ConfigModel childModel, int parameterType) {
        MethodMetaData methodMetaData = new MethodMetaData();
        ArrayList interfaces = new ArrayList();
        HashMap<String, ParameterMetaData> params = new HashMap<String, ParameterMetaData>();
        try {
            Class<?> configBeanProxy = ((ClassLoader)childModel.classLoaderHolder.get()).loadClass(childModel.targetTypeName);
            ResourceUtil.getInterfaces(configBeanProxy, interfaces);
            Set attributeNames = childModel.getAttributeNames();
            for (String attributeName : attributeNames) {
                String methodName = ResourceUtil.getAttributeMethodName(attributeName);
                ParameterMetaData parameterMetaData = (ParameterMetaData)params.get(attributeName = Util.eleminateHypen(attributeName));
                if (parameterMetaData == null) {
                    parameterMetaData = new ParameterMetaData();
                    params.put(attributeName, parameterMetaData);
                }
                for (int i = interfaces.size() - 1; i >= 0; --i) {
                    Class intf = (Class)interfaces.get(i);
                    try {
                        Method method = intf.getMethod(methodName, new Class[0]);
                        Attribute attribute = method.getAnnotation(Attribute.class);
                        if (attribute == null) continue;
                        ParameterMetaData localParam = ResourceUtil.getParameterMetaData(attribute);
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "defaultValue");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "key");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "type");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "optional");
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                try {
                    Method method = configBeanProxy.getMethod(methodName, new Class[0]);
                    Attribute attribute = method.getAnnotation(Attribute.class);
                    if (attribute != null) {
                        ParameterMetaData localParam = ResourceUtil.getParameterMetaData(attribute);
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "defaultValue");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "key");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "type");
                        ResourceUtil.copyParameterMetaDataAttribute(localParam, parameterMetaData, "optional");
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (parameterType == 0) {
                    methodMetaData.putQueryParamMetaData(attributeName, parameterMetaData);
                    continue;
                }
                methodMetaData.putParameterMetaData(attributeName, parameterMetaData);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        return methodMetaData;
    }

    protected static void copyParameterMetaDataAttribute(ParameterMetaData from, ParameterMetaData to, String key) {
        if (from.getAttributeValue(key) != null) {
            to.putAttribute(key, from.getAttributeValue(key));
        }
    }

    protected static void getInterfaces(Class<?> clazz, List<Class<?>> interfaces) {
        for (Class<?> intf : clazz.getInterfaces()) {
            interfaces.add(intf);
            ResourceUtil.getInterfaces(intf, interfaces);
        }
    }

    public static Collection<CommandModel.ParamModel> getParamMetaData(String commandName, Habitat habitat, Logger logger) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection params = cm.getParameters();
        return params;
    }

    public static Collection<CommandModel.ParamModel> getParamMetaData(String commandName, Collection<String> commandParamsToSkip, Habitat habitat, Logger logger) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection parameterNames = cm.getParametersNames();
        ArrayList<CommandModel.ParamModel> metaData = new ArrayList<CommandModel.ParamModel>();
        for (String name : parameterNames) {
            CommandModel.ParamModel paramModel = cm.getModelFor(name);
            String parameterName = paramModel.getParam().primary() ? "id" : paramModel.getName();
            boolean skipParameter = false;
            try {
                skipParameter = commandParamsToSkip.contains(parameterName);
            }
            catch (Exception e) {
                String errorMessage = Util.localStrings.getLocalString("rest.metadata.skip.error", "Parameter \"{0}\" may be redundant and not required.", new Object[]{parameterName});
                Logger.getLogger(ResourceUtil.class.getName()).log(Level.INFO, null, errorMessage);
                Logger.getLogger(ResourceUtil.class.getName()).log(Level.INFO, null, e);
            }
            if (skipParameter) continue;
            metaData.add(paramModel);
        }
        return metaData;
    }

    public static void purgeEmptyEntries(Map<String, String> data) {
        Set<String> keys = data.keySet();
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (data.get(key) != null && data.get(key).length() >= 1) continue;
            data.remove(key);
            iterator = keys.iterator();
        }
    }

    public static Response getResponse(int status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (ResourceUtil.isBrowser(requestHeaders)) {
            message = Util.getHtml(message, uriInfo, false);
        }
        return Response.status((int)status).entity((Object)message).build();
    }

    public static ActionReportResult getActionReportResult(int status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (ResourceUtil.isBrowser(requestHeaders)) {
            message = Util.getHtml(message, uriInfo, false);
        }
        RestActionReporter ar = new RestActionReporter();
        ActionReportResult result = new ActionReportResult(ar);
        if (status >= 200 && status <= 299) {
            ar.setSuccess();
        } else {
            ar.setFailure();
            result.setErrorMessage(message);
            result.setIsError(true);
        }
        ar.setMessage(message);
        result.setStatusCode(status);
        return result;
    }

    public static Response getDeleteResponse(int status, String message, HttpHeaders requestHeaders, UriInfo uriInfo) {
        if (ResourceUtil.isBrowser(requestHeaders)) {
            message = Util.getHtml(message, uriInfo, true);
        }
        return Response.status((int)status).entity((Object)message).build();
    }

    public static void addQueryString(MultivaluedMap<String, String> qs, Map<String, String> data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                data.put(key, value);
            }
        }
    }

    public static void addQueryString(MultivaluedMap<String, String> qs, Properties data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                data.put(key, value);
            }
        }
    }

    static ParameterMetaData getParameterMetaData(CommandModel.ParamModel paramModel) {
        Param param = paramModel.getParam();
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("type", ResourceUtil.getXsdType(paramModel.getType().toString()));
        parameterMetaData.putAttribute("optional", Boolean.toString(param.optional()));
        String val = param.defaultValue();
        if (val != null && !val.equals("\u0000")) {
            parameterMetaData.putAttribute("defaultValue", param.defaultValue());
        }
        parameterMetaData.putAttribute("acceptableValues", param.acceptableValues());
        return parameterMetaData;
    }

    static ParameterMetaData getParameterMetaData(Attribute attribute) {
        ParameterMetaData parameterMetaData = new ParameterMetaData();
        parameterMetaData.putAttribute("type", ResourceUtil.getXsdType(attribute.dataType().toString()));
        parameterMetaData.putAttribute("optional", Boolean.toString(!attribute.required()));
        if (!attribute.defaultValue().equals("\u0000")) {
            parameterMetaData.putAttribute("defaultValue", attribute.defaultValue());
        }
        parameterMetaData.putAttribute("key", Boolean.toString(attribute.key()));
        return parameterMetaData;
    }

    private static boolean renameParameter(Map<String, String> data, String parameterToRename, String newName) {
        if (data.containsKey(parameterToRename)) {
            String value = data.get(parameterToRename);
            data.remove(parameterToRename);
            data.put(newName, value);
            return true;
        }
        return false;
    }

    private static void print(Collection<CommandModel.ParamModel> params) {
        for (CommandModel.ParamModel pm : params) {
            System.out.println("Command Param: " + pm.getName());
            System.out.println("Command Param Type: " + pm.getType());
            System.out.println("Command Param Name: " + pm.getParam().name());
            System.out.println("Command Param Shortname: " + pm.getParam().shortName());
        }
    }

    private static boolean isBrowser(HttpHeaders requestHeaders) {
        boolean isClientAcceptsHtml = false;
        MediaType media = requestHeaders.getMediaType();
        List acceptHeaders = requestHeaders.getRequestHeader("Accept");
        for (String header : acceptHeaders) {
            if (!header.contains("text/html")) continue;
            isClientAcceptsHtml = true;
            break;
        }
        return media != null && media.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && isClientAcceptsHtml;
    }

    private static String getXsdType(String javaType) {
        if (javaType.indexOf("java.lang.String") != -1) {
            return "string";
        }
        if (javaType.indexOf("java.lang.Boolean") != -1) {
            return "boolean";
        }
        if (javaType.indexOf("java.lang.Integer") != -1) {
            return "int";
        }
        if (javaType.indexOf("java.util.Properties") != -1) {
            return "string";
        }
        return javaType;
    }

    static String getAttributeMethodName(String attributeName) {
        return Util.methodNameFromDtdName(attributeName, "get");
    }

    public static HashMap<String, String> translateCamelCasedNamesToCommandParamNames(HashMap<String, String> sourceMap, String commandName, Habitat habitat, Logger logger) {
        CommandRunner cr = (CommandRunner)habitat.getComponent(CommandRunner.class);
        CommandModel cm = cr.getModel(commandName, logger);
        Collection paramModels = cm.getParameters();
        HashMap<String, String> translatedMap = new HashMap<String, String>();
        for (CommandModel.ParamModel paramModel : paramModels) {
            Param param = paramModel.getParam();
            String camelCaseName = param.alias();
            if (!sourceMap.containsKey(camelCaseName)) continue;
            String paramValue = sourceMap.remove(camelCaseName);
            translatedMap.put(paramModel.getName(), paramValue);
        }
        translatedMap.putAll(sourceMap);
        return translatedMap;
    }

    private static String split(String lookback, String lookahead) {
        return "((?<=" + lookback + ")(?=" + lookahead + "))";
    }

    private static String or(String ... tokens) {
        StringBuilder buf = new StringBuilder();
        for (String t : tokens) {
            if (buf.length() > 0) {
                buf.append('|');
            }
            buf.append(t);
        }
        return buf.toString();
    }

    public static String convertToXMLName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 5);
        for (String t : TOKENIZER.split(name)) {
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(t.toLowerCase());
        }
        return buf.toString();
    }

    public static HashMap<String, String> translateCamelCasedNamesToXMLNames(Map<String, String> sourceData) {
        HashMap<String, String> convertedData = new HashMap<String, String>(sourceData.size());
        for (Map.Entry<String, String> entry : sourceData.entrySet()) {
            String camelCasedKeyName = entry.getKey();
            String xmlKeyName = ResourceUtil.convertToXMLName(camelCasedKeyName);
            convertedData.put(xmlKeyName, entry.getValue());
        }
        return convertedData;
    }

    public static String getResultType(HttpHeaders requestHeaders) {
        String result = "html";
        String firstOne = null;
        List lmt = requestHeaders.getAcceptableMediaTypes();
        for (MediaType mt : lmt) {
            if (mt.getSubtype().equals("html")) {
                return result;
            }
            if (mt.getSubtype().equals("*")) {
                return result;
            }
            if (firstOne != null) continue;
            firstOne = mt.getSubtype();
        }
        if (firstOne != null) {
            return firstOne;
        }
        return result;
    }

    public static Map buildMethodMetadataMap(MethodMetaData mmd, boolean isQuery) {
        TreeMap<String, Map<String, String>> map = new TreeMap<String, Map<String, String>>();
        Set<String> params = isQuery ? mmd.queryParams() : mmd.parameters();
        for (String param : params) {
            ParameterMetaData parameterMetaData = isQuery ? mmd.getQueryParamMetaData(param) : mmd.getParameterMetaData(param);
            map.put(param, ResourceUtil.processAttributes(parameterMetaData.attributes(), parameterMetaData));
        }
        return map;
    }

    public static Map<String, String> processAttributes(Set<String> attributes, ParameterMetaData parameterMetaData) {
        HashMap<String, String> pmdm = new HashMap<String, String>();
        for (String attributeName : attributes) {
            String attributeValue = parameterMetaData.getAttributeValue(attributeName);
            pmdm.put(attributeName, attributeValue);
        }
        return pmdm;
    }

    public static Map<String, String> getResourceLinks(Dom dom, UriInfo uriInfo) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        Set elementNames = dom.model.getElementNames();
        for (String elementName : elementNames) {
            if (elementName.equals("*")) {
                ConfigModel.Node node = (ConfigModel.Node)dom.model.getElement(elementName);
                ConfigModel childModel = node.getModel();
                List<ConfigModel> lcm = ResourceUtil.getRealChildConfigModels(childModel, dom.document);
                Collections.sort(lcm, new ConfigModelComparator());
                if (lcm == null) continue;
                for (ConfigModel cmodel : lcm) {
                    links.put(cmodel.getTagName(), ProviderUtil.getElementLink(uriInfo, cmodel.getTagName()));
                }
                continue;
            }
            links.put(elementName, ProviderUtil.getElementLink(uriInfo, elementName));
        }
        String beanName = ResourceUtil.getUnqualifiedTypeName(dom.model.targetTypeName);
        for (String[] resource : ResourcesGeneratorBase.configBeanCustomResources) {
            if (!resource[0].equals(beanName)) continue;
            links.put(resource[2], ProviderUtil.getElementLink(uriInfo, resource[2]));
        }
        return links;
    }

    public static String getUnqualifiedTypeName(String qualifiedTypeName) {
        return qualifiedTypeName.substring(qualifiedTypeName.lastIndexOf(".") + 1, qualifiedTypeName.length());
    }

    public static boolean isOnlyATag(ConfigModel model) {
        return model.getAttributeNames().isEmpty() && model.getElementNames().isEmpty();
    }

    public static List<ConfigModel> getRealChildConfigModels(ConfigModel childModel, DomDocument domDocument) {
        ArrayList<ConfigModel> retlist = new ArrayList<ConfigModel>();
        try {
            Class<?> subType = ((ClassLoader)childModel.classLoaderHolder.get()).loadClass(childModel.targetTypeName);
            List list = domDocument.getAllModelsImplementing(subType);
            if (list != null) {
                for (ConfigModel el : list) {
                    if (ResourceUtil.isOnlyATag(el)) {
                        retlist.addAll(ResourceUtil.getRealChildConfigModels(el, domDocument));
                        continue;
                    }
                    retlist.add(el);
                }
            } else if (!ResourceUtil.isOnlyATag(childModel)) {
                retlist.add(childModel);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return retlist;
    }

    public static Map<String, String> getResourceLinks(List<Dom> proxyList, UriInfo uriInfo) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        Collections.sort(proxyList, new DomConfigurator());
        for (Dom proxy : proxyList) {
            try {
                links.put(proxy.getKey(), ProviderUtil.getElementLink(uriInfo, proxy.getKey()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return links;
    }

    public static List<Map<String, String>> getCommandLinks(String[][] commandResourcesPaths) {
        ArrayList<Map<String, String>> commands = new ArrayList<Map<String, String>>();
        for (String[] array : commandResourcesPaths) {
            HashMap<String, String> command = new HashMap<String, String>();
            command.put("command", array[0]);
            command.put("method", array[1]);
            command.put("path", array[2]);
            commands.add(command);
        }
        return commands;
    }

    public static void addMethodMetaData(ActionReport ar, Map<String, MethodMetaData> mmd) {
        MethodMetaData deleteMetaData;
        ArrayList methodMetaData = new ArrayList();
        methodMetaData.add(new HashMap(){
            {
                this.put("name", "GET");
            }
        });
        MethodMetaData postMetaData = mmd.get("POST");
        HashMap<String, Object> postMetaDataMap = new HashMap<String, Object>();
        if (postMetaData != null) {
            postMetaDataMap.put("name", "POST");
            if (postMetaData.sizeQueryParamMetaData() > 0) {
                postMetaDataMap.put(QUERY_PARAMETERS, ResourceUtil.buildMethodMetadataMap(postMetaData, true));
            }
            if (postMetaData.sizeParameterMetaData() > 0) {
                postMetaDataMap.put(MESSAGE_PARAMETERS, ResourceUtil.buildMethodMetadataMap(postMetaData, false));
            }
            methodMetaData.add(postMetaDataMap);
        }
        if ((deleteMetaData = mmd.get("DELETE")) != null) {
            HashMap<String, Object> deleteMetaDataMap = new HashMap<String, Object>();
            deleteMetaDataMap.put("name", "DELETE");
            deleteMetaDataMap.put(MESSAGE_PARAMETERS, ResourceUtil.buildMethodMetadataMap(deleteMetaData, false));
            methodMetaData.add(deleteMetaDataMap);
        }
        ar.getExtraProperties().put("methods", methodMetaData);
    }

    static {
        String pattern = ResourceUtil.or(ResourceUtil.split("x", "X"), ResourceUtil.split("X", "Xx"), ResourceUtil.split("\\d", "\\D"));
        pattern = pattern.replace("x", "\\p{Lower}").replace("X", "\\p{Upper}");
        TOKENIZER = Pattern.compile(pattern);
    }
}

